/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiobelda.compose.vectorize.generator.vector;

import dev.sergiobelda.compose.vectorize.generator.vector.PathNode;
import dev.sergiobelda.compose.vectorize.generator.vector.PathNodeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Ldev/sergiobelda/compose/vectorize/generator/vector/PathParser;", "", "()V", "copyOfRange", "", "original", "start", "", "end", "extract", "", "s", "", "result", "Ldev/sergiobelda/compose/vectorize/generator/vector/PathParser$ExtractFloatResult;", "getFloats", "nextStart", "parsePathString", "", "Ldev/sergiobelda/compose/vectorize/generator/vector/PathNode;", "pathData", "ExtractFloatResult", "compose-vectorize-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\ndev/sergiobelda/compose/vectorize/generator/vector/PathParser\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,177:1\n107#2:178\n79#2,22:179\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\ndev/sergiobelda/compose/vectorize/generator/vector/PathParser\n*L\n42#1:178\n42#1:179,22\n*E\n"})
public final class PathParser {
    @NotNull
    public static final PathParser INSTANCE = new PathParser();

    private PathParser() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PathNode> parsePathString(@NotNull String pathData) {
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        List nodes = new ArrayList();
        int start = 0;
        int end = 1;
        while (end < pathData.length()) {
            String s;
            void $this$trim$iv;
            end = this.nextStart(pathData, end);
            Intrinsics.checkNotNullExpressionValue((Object)pathData.substring(start, end), (String)"substring(...)");
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)(s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() > 0) {
                float[] args = this.getFloats(s);
                PathParser.parsePathString$addNode(nodes, s.charAt(0), args);
            }
            start = end++;
        }
        if (end - start == 1 && start < pathData.length()) {
            PathParser.parsePathString$addNode(nodes, pathData.charAt(start), new float[0]);
        }
        return nodes;
    }

    private final int nextStart(String s, int end) {
        int index;
        char c = '\u0000';
        for (index = end; index < s.length(); ++index) {
            c = s.charAt(index);
            if ((c - 65) * (c - 90) > 0 && (c - 97) * (c - 122) > 0 || c == 'e' || c == 'E') continue;
            return index;
        }
        return index;
    }

    private final float[] getFloats(String s) throws NumberFormatException {
        if (s.charAt(0) == 'z' || s.charAt(0) == 'Z') {
            return new float[0];
        }
        float[] results = new float[s.length()];
        int count = 0;
        int startPosition = 1;
        int endPosition = 0;
        ExtractFloatResult result = new ExtractFloatResult(0, false, 3, null);
        int totalLength = s.length();
        while (startPosition < totalLength) {
            this.extract(s, startPosition, result);
            endPosition = result.getEndPosition();
            if (startPosition < endPosition) {
                int n = count++;
                String string = s.substring(startPosition, endPosition);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                results[n] = Float.parseFloat(string);
            }
            startPosition = result.getEndWithNegativeOrDot() ? endPosition : endPosition + 1;
        }
        return this.copyOfRange(results, 0, count);
    }

    private final float[] copyOfRange(float[] original, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException();
        }
        int originalLength = original.length;
        if (start < 0 || start > originalLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int resultLength = end - start;
        int copyLength = Math.min(resultLength, originalLength - start);
        float[] result = new float[resultLength];
        ArraysKt.copyInto((float[])original, (float[])result, (int)0, (int)start, (int)(start + copyLength));
        return result;
    }

    private final void extract(String s, int start, ExtractFloatResult result) {
        int currentIndex;
        boolean foundSeparator = false;
        result.setEndWithNegativeOrDot(false);
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            switch (s.charAt(currentIndex)) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    result.setEndWithNegativeOrDot(true);
                    break;
                }
                case '.': {
                    if (!secondDot) {
                        secondDot = true;
                        break;
                    }
                    foundSeparator = true;
                    result.setEndWithNegativeOrDot(true);
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator) break;
        }
        result.setEndPosition(currentIndex);
    }

    private static final void parsePathString$addNode(List<PathNode> nodes, char cmd, float[] args) {
        nodes.addAll((Collection<PathNode>)PathNodeKt.toPathNodes(cmd, args));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Ldev/sergiobelda/compose/vectorize/generator/vector/PathParser$ExtractFloatResult;", "", "endPosition", "", "endWithNegativeOrDot", "", "(IZ)V", "getEndPosition", "()I", "setEndPosition", "(I)V", "getEndWithNegativeOrDot", "()Z", "setEndWithNegativeOrDot", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "compose-vectorize-gradle-plugin"})
    private static final class ExtractFloatResult {
        private int endPosition;
        private boolean endWithNegativeOrDot;

        public ExtractFloatResult(int endPosition, boolean endWithNegativeOrDot) {
            this.endPosition = endPosition;
            this.endWithNegativeOrDot = endWithNegativeOrDot;
        }

        public /* synthetic */ ExtractFloatResult(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(n, bl);
        }

        public final int getEndPosition() {
            return this.endPosition;
        }

        public final void setEndPosition(int n) {
            this.endPosition = n;
        }

        public final boolean getEndWithNegativeOrDot() {
            return this.endWithNegativeOrDot;
        }

        public final void setEndWithNegativeOrDot(boolean bl) {
            this.endWithNegativeOrDot = bl;
        }

        public final int component1() {
            return this.endPosition;
        }

        public final boolean component2() {
            return this.endWithNegativeOrDot;
        }

        @NotNull
        public final ExtractFloatResult copy(int endPosition, boolean endWithNegativeOrDot) {
            return new ExtractFloatResult(endPosition, endWithNegativeOrDot);
        }

        public static /* synthetic */ ExtractFloatResult copy$default(ExtractFloatResult extractFloatResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = extractFloatResult.endPosition;
            }
            if ((n2 & 2) != 0) {
                bl = extractFloatResult.endWithNegativeOrDot;
            }
            return extractFloatResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "ExtractFloatResult(endPosition=" + this.endPosition + ", endWithNegativeOrDot=" + this.endWithNegativeOrDot + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.endPosition);
            result = result * 31 + Boolean.hashCode(this.endWithNegativeOrDot);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtractFloatResult)) {
                return false;
            }
            ExtractFloatResult extractFloatResult = (ExtractFloatResult)other;
            if (this.endPosition != extractFloatResult.endPosition) {
                return false;
            }
            return this.endWithNegativeOrDot == extractFloatResult.endWithNegativeOrDot;
        }

        public ExtractFloatResult() {
            this(0, false, 3, null);
        }
    }
}

