/*
 * Decompiled with CFR 0.152.
 */
package dev.paseto.jpaseto.impl;

import dev.paseto.jpaseto.PasetoV2LocalBuilder;
import dev.paseto.jpaseto.impl.AbstractPasetoBuilder;
import dev.paseto.jpaseto.impl.CryptoProviders;
import dev.paseto.jpaseto.impl.crypto.V2LocalCryptoProvider;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public class DefaultPasetoV2LocalBuilder
extends AbstractPasetoBuilder<PasetoV2LocalBuilder>
implements PasetoV2LocalBuilder {
    private static final String HEADER = "v2.local.";
    private SecretKey sharedSecret = null;
    private final V2LocalCryptoProvider cryptoProvider;

    public DefaultPasetoV2LocalBuilder() {
        this(CryptoProviders.v2LocalCryptoProvider());
    }

    DefaultPasetoV2LocalBuilder(V2LocalCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public PasetoV2LocalBuilder setSharedSecret(SecretKey sharedSecret) {
        this.sharedSecret = sharedSecret;
        return this;
    }

    public String compact() {
        byte[] payload = this.payloadAsBytes();
        byte[] footer = this.footerAsBytes();
        byte[] randomBytes = new byte[24];
        try {
            SecureRandom.getInstanceStrong().nextBytes(randomBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("JVM does not provide a strong secure random number generator", e);
        }
        byte[] nonce = this.cryptoProvider.blake2b(payload, randomBytes);
        byte[] cipherText = this.cryptoProvider.encrypt(payload, footer, nonce, this.sharedSecret);
        String base64d = this.noPadBase64(new byte[][]{cipherText});
        return HEADER + base64d + this.footerToString(footer);
    }
}

