/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ValueNotConvertableError;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Structure {
    public Set<String> keySet();

    public Value getValue(String var1);

    public Map<String, Value> asMap();

    public Map<String, Object> asObjectMap();

    default public Object convertValue(Value value) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isNumber() && !value.isNull()) {
            Number numberValue = (Number)value.asObject();
            if (numberValue instanceof Double) {
                return numberValue.doubleValue();
            }
            if (numberValue instanceof Integer) {
                return numberValue.intValue();
            }
        }
        if (value.isString()) {
            return value.asString();
        }
        if (value.isInstant()) {
            return value.asInstant();
        }
        if (value.isList()) {
            return value.asList().stream().map(this::convertValue).collect(Collectors.toList());
        }
        if (value.isStructure()) {
            Structure s = value.asStructure();
            return s.asMap().entrySet().stream().collect(HashMap::new, (accumulated, entry) -> accumulated.put(entry.getKey(), this.convertValue((Value)entry.getValue())), HashMap::putAll);
        }
        throw new ValueNotConvertableError();
    }

    default public <T extends Structure> Map<String, Value> merge(Function<Map<String, Value>, Structure> newStructure, Map<String, Value> base, Map<String, Value> overriding) {
        HashMap<String, Value> merged = new HashMap<String, Value>(base);
        for (Map.Entry<String, Value> overridingEntry : overriding.entrySet()) {
            String key = overridingEntry.getKey();
            if (overridingEntry.getValue().isStructure() && merged.containsKey(key) && ((Value)merged.get(key)).isStructure()) {
                Structure mergedValue = ((Value)merged.get(key)).asStructure();
                Structure overridingValue = overridingEntry.getValue().asStructure();
                Map<String, Value> newMap = this.merge(newStructure, mergedValue.asMap(), overridingValue.asMap());
                merged.put(key, new Value(newStructure.apply(newMap)));
                continue;
            }
            merged.put(key, overridingEntry.getValue());
        }
        return merged;
    }

    public static Structure mapToStructure(Map<String, Object> map) {
        return new MutableStructure(map.entrySet().stream().collect(HashMap::new, (accumulated, entry) -> accumulated.put(entry.getKey(), Value.objectToValue(entry.getValue())), HashMap::putAll));
    }
}

