/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.NoOpProvider;
import dev.openfeature.sdk.OpenFeatureAPI;
import dev.openfeature.sdk.ProviderState;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProviderRepository {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProviderRepository.class);
    private final Map<String, FeatureProvider> providers = new ConcurrentHashMap<String, FeatureProvider>();
    private final AtomicReference<FeatureProvider> defaultProvider = new AtomicReference<NoOpProvider>(new NoOpProvider());
    private final ExecutorService taskExecutor = Executors.newCachedThreadPool(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    });

    ProviderRepository() {
    }

    public FeatureProvider getProvider() {
        return this.defaultProvider.get();
    }

    public FeatureProvider getProvider(String name) {
        return Optional.ofNullable(name).map(this.providers::get).orElse(this.defaultProvider.get());
    }

    public List<String> getClientNamesForProvider(FeatureProvider provider) {
        return this.providers.entrySet().stream().filter(entry -> ((FeatureProvider)entry.getValue()).equals(provider)).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
    }

    public Set<String> getAllBoundClientNames() {
        return this.providers.keySet();
    }

    public boolean isDefaultProvider(FeatureProvider provider) {
        return this.getProvider().equals(provider);
    }

    public void setProvider(FeatureProvider provider, Consumer<FeatureProvider> afterSet, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, String> afterError, boolean waitForInit) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        this.prepareAndInitializeProvider(null, provider, afterSet, afterInit, afterShutdown, afterError, waitForInit);
    }

    public void setProvider(String clientName, FeatureProvider provider, Consumer<FeatureProvider> afterSet, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, String> afterError, boolean waitForInit) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        if (clientName == null) {
            throw new IllegalArgumentException("clientName cannot be null");
        }
        this.prepareAndInitializeProvider(clientName, provider, afterSet, afterInit, afterShutdown, afterError, waitForInit);
    }

    private void prepareAndInitializeProvider(@Nullable String clientName, FeatureProvider newProvider, Consumer<FeatureProvider> afterSet, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, String> afterError, boolean waitForInit) {
        FeatureProvider oldProvider = clientName != null ? this.providers.put(clientName, newProvider) : this.defaultProvider.getAndSet(newProvider);
        afterSet.accept(newProvider);
        if (waitForInit) {
            this.initializeProvider(newProvider, afterInit, afterShutdown, afterError, oldProvider);
        } else {
            this.taskExecutor.submit(() -> this.initializeProvider(newProvider, afterInit, afterShutdown, afterError, oldProvider));
        }
    }

    private void initializeProvider(FeatureProvider newProvider, Consumer<FeatureProvider> afterInit, Consumer<FeatureProvider> afterShutdown, BiConsumer<FeatureProvider, String> afterError, FeatureProvider oldProvider) {
        try {
            if (ProviderState.NOT_READY.equals((Object)newProvider.getState())) {
                newProvider.initialize(OpenFeatureAPI.getInstance().getEvaluationContext());
                afterInit.accept(newProvider);
            }
            this.shutDownOld(oldProvider, afterShutdown);
        }
        catch (Exception e) {
            log.error("Exception when initializing feature provider {}", (Object)newProvider.getClass().getName(), (Object)e);
            afterError.accept(newProvider, e.getMessage());
        }
    }

    private void shutDownOld(FeatureProvider oldProvider, Consumer<FeatureProvider> afterShutdown) {
        if (oldProvider != null && !this.isProviderRegistered(oldProvider)) {
            this.shutdownProvider(oldProvider);
            afterShutdown.accept(oldProvider);
        }
    }

    private boolean isProviderRegistered(FeatureProvider oldProvider) {
        return oldProvider != null && (this.providers.containsValue(oldProvider) || this.defaultProvider.get().equals(oldProvider));
    }

    private void shutdownProvider(FeatureProvider provider) {
        this.taskExecutor.submit(() -> {
            try {
                provider.shutdown();
            }
            catch (Exception e) {
                log.error("Exception when shutting down feature provider {}", (Object)provider.getClass().getName(), (Object)e);
            }
        });
    }

    public void shutdown() {
        Stream.concat(Stream.of(this.defaultProvider.get()), this.providers.values().stream()).distinct().forEach(this::shutdownProvider);
        this.setProvider(new NoOpProvider(), fp -> {}, fp -> {}, fp -> {}, (fp, message) -> {}, false);
        this.providers.clear();
        this.taskExecutor.shutdown();
    }
}

