/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk.providers.memory;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEventDetails;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ProviderNotReadyError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import dev.openfeature.sdk.providers.memory.Flag;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryProvider.class);
    private static final String NAME = "InMemoryProvider";
    private Map<String, Flag<?>> flags;
    private ProviderState state = ProviderState.NOT_READY;

    @Override
    public Metadata getMetadata() {
        return () -> NAME;
    }

    public InMemoryProvider(Map<String, Flag<?>> flags) {
        this.flags = new HashMap(flags);
    }

    @Override
    public void initialize(EvaluationContext evaluationContext) throws Exception {
        super.initialize(evaluationContext);
        this.state = ProviderState.READY;
        log.debug("finished initializing provider, state: {}", (Object)this.state);
    }

    public void updateFlags(Map<String, Flag<?>> flags) {
        HashSet<String> flagsChanged = new HashSet<String>();
        flagsChanged.addAll(this.flags.keySet());
        flagsChanged.addAll(flags.keySet());
        this.flags = new HashMap(flags);
        Object details = ((ProviderEventDetails.ProviderEventDetailsBuilder)((ProviderEventDetails.ProviderEventDetailsBuilder)ProviderEventDetails.builder().flagsChanged(new ArrayList<String>(flagsChanged))).message("flags changed")).build();
        this.emitProviderConfigurationChanged((ProviderEventDetails)details);
    }

    public void updateFlag(String flagKey, Flag<?> flag) {
        this.flags.put(flagKey, flag);
        Object details = ((ProviderEventDetails.ProviderEventDetailsBuilder)((ProviderEventDetails.ProviderEventDetailsBuilder)ProviderEventDetails.builder().flagsChanged(Arrays.asList(flagKey))).message("flag added/updated")).build();
        this.emitProviderConfigurationChanged((ProviderEventDetails)details);
    }

    @Override
    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext evaluationContext) {
        return this.getEvaluation(key, evaluationContext, Boolean.class);
    }

    @Override
    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext evaluationContext) {
        return this.getEvaluation(key, evaluationContext, String.class);
    }

    @Override
    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext evaluationContext) {
        return this.getEvaluation(key, evaluationContext, Integer.class);
    }

    @Override
    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext evaluationContext) {
        return this.getEvaluation(key, evaluationContext, Double.class);
    }

    @Override
    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext evaluationContext) {
        return this.getEvaluation(key, evaluationContext, Value.class);
    }

    private <T> ProviderEvaluation<T> getEvaluation(String key, EvaluationContext evaluationContext, Class<?> expectedType) throws OpenFeatureError {
        Object value;
        if (!ProviderState.READY.equals((Object)this.state)) {
            if (ProviderState.NOT_READY.equals((Object)this.state)) {
                throw new ProviderNotReadyError("provider not yet initialized");
            }
            throw new GeneralError("unknown error");
        }
        Flag<?> flag = this.flags.get(key);
        if (flag == null) {
            throw new FlagNotFoundError("flag " + key + "not found");
        }
        if (flag.getContextEvaluator() != null) {
            value = flag.getContextEvaluator().evaluate(flag, evaluationContext);
        } else {
            if (!expectedType.isInstance(flag.getVariants().get(flag.getDefaultVariant()))) {
                throw new TypeMismatchError("flag " + key + "is not of expected type");
            }
            value = flag.getVariants().get(flag.getDefaultVariant());
        }
        return ProviderEvaluation.builder().value(value).variant(flag.getDefaultVariant()).reason(Reason.STATIC.toString()).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getNAME() {
        return NAME;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProviderState getState() {
        return this.state;
    }
}

