/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Value;
import java.util.ArrayList;
import java.util.List;

public interface FeatureProvider {
    public Metadata getMetadata();

    default public List<Hook> getProviderHooks() {
        return new ArrayList<Hook>();
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String var1, Boolean var2, EvaluationContext var3);

    public ProviderEvaluation<String> getStringEvaluation(String var1, String var2, EvaluationContext var3);

    public ProviderEvaluation<Integer> getIntegerEvaluation(String var1, Integer var2, EvaluationContext var3);

    public ProviderEvaluation<Double> getDoubleEvaluation(String var1, Double var2, EvaluationContext var3);

    public ProviderEvaluation<Value> getObjectEvaluation(String var1, Value var2, EvaluationContext var3);

    default public void initialize(EvaluationContext evaluationContext) throws Exception {
    }

    default public void shutdown() {
    }

    default public ProviderState getState() {
        return ProviderState.READY;
    }
}

