/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Value
implements Cloneable {
    private final Object innerObject;

    public Value() {
        this.innerObject = null;
    }

    public Value(Object value) throws InstantiationException {
        this.innerObject = value;
        if (!(this.isNull() || this.isBoolean() || this.isString() || this.isNumber() || this.isStructure() || this.isList() || this.isInstant())) {
            throw new InstantiationException("Invalid value type: " + value.getClass());
        }
    }

    public Value(Value value) {
        this.innerObject = value.innerObject;
    }

    public Value(Boolean value) {
        this.innerObject = value;
    }

    public Value(String value) {
        this.innerObject = value;
    }

    public Value(Integer value) {
        this.innerObject = value;
    }

    public Value(Double value) {
        this.innerObject = value;
    }

    public Value(Structure value) {
        this.innerObject = value;
    }

    public Value(List<Value> value) {
        this.innerObject = value;
    }

    public Value(Instant value) {
        this.innerObject = value;
    }

    public boolean isNull() {
        return this.innerObject == null;
    }

    public boolean isBoolean() {
        return this.innerObject instanceof Boolean;
    }

    public boolean isString() {
        return this.innerObject instanceof String;
    }

    public boolean isNumber() {
        return this.innerObject instanceof Number;
    }

    public boolean isStructure() {
        return this.innerObject instanceof Structure;
    }

    public boolean isList() {
        if (!(this.innerObject instanceof List)) {
            return false;
        }
        List list = (List)this.innerObject;
        if (list.isEmpty()) {
            return true;
        }
        for (Object obj : list) {
            if (obj instanceof Value) continue;
            return false;
        }
        return true;
    }

    public boolean isInstant() {
        return this.innerObject instanceof Instant;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="This is not a plain true/false method. It's understood it can return null.")
    public Boolean asBoolean() {
        if (this.isBoolean()) {
            return (Boolean)this.innerObject;
        }
        return null;
    }

    public Object asObject() {
        return this.innerObject;
    }

    public String asString() {
        if (this.isString()) {
            return (String)this.innerObject;
        }
        return null;
    }

    public Integer asInteger() {
        if (this.isNumber() && !this.isNull()) {
            return ((Number)this.innerObject).intValue();
        }
        return null;
    }

    public Double asDouble() {
        if (this.isNumber() && !this.isNull()) {
            return ((Number)this.innerObject).doubleValue();
        }
        return null;
    }

    public Structure asStructure() {
        if (this.isStructure()) {
            return (Structure)this.innerObject;
        }
        return null;
    }

    public List<Value> asList() {
        if (this.isList()) {
            return (List)this.innerObject;
        }
        return null;
    }

    public Instant asInstant() {
        if (this.isInstant()) {
            return (Instant)this.innerObject;
        }
        return null;
    }

    protected Value clone() {
        if (this.isList()) {
            List<Value> copy = this.asList().stream().map(Value::new).collect(Collectors.toList());
            return new Value(copy);
        }
        if (this.isStructure()) {
            Map<String, Value> copy = this.asStructure().asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Value)e.getValue()).clone()));
            return new Value(new ImmutableStructure(copy));
        }
        if (this.isInstant()) {
            Instant copy = Instant.ofEpochMilli(this.asInstant().toEpochMilli());
            return new Value(copy);
        }
        return new Value(this.asObject());
    }

    public static Value objectToValue(Object object) {
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new Value((String)object);
        }
        if (object instanceof Boolean) {
            return new Value((Boolean)object);
        }
        if (object instanceof Integer) {
            return new Value((Integer)object);
        }
        if (object instanceof Double) {
            return new Value((Double)object);
        }
        if (object instanceof Structure) {
            return new Value((Structure)object);
        }
        if (object instanceof List) {
            return new Value(((List)object).stream().map(o -> Value.objectToValue(o)).collect(Collectors.toList()));
        }
        if (object instanceof Instant) {
            return new Value((Instant)object);
        }
        if (object instanceof Map) {
            return new Value(Structure.mapToStructure((Map)object));
        }
        throw new TypeMismatchError("Flag value " + object + " had unexpected type " + object.getClass() + ".");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Value(innerObject=" + this.innerObject + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$innerObject = this.innerObject;
        Object other$innerObject = other.innerObject;
        return !(this$innerObject == null ? other$innerObject != null : !this$innerObject.equals(other$innerObject));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $innerObject = this.innerObject;
        result = result * 59 + ($innerObject == null ? 43 : $innerObject.hashCode());
        return result;
    }
}

