/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableMetadata {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImmutableMetadata.class);
    private final Map<String, Object> metadata;

    private ImmutableMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String getString(String key) {
        return this.getValue(key, String.class);
    }

    public Integer getInteger(String key) {
        return this.getValue(key, Integer.class);
    }

    public Long getLong(String key) {
        return this.getValue(key, Long.class);
    }

    public Float getFloat(String key) {
        return this.getValue(key, Float.class);
    }

    public Double getDouble(String key) {
        return this.getValue(key, Double.class);
    }

    public Boolean getBoolean(String key) {
        return this.getValue(key, Boolean.class);
    }

    public <T> T getValue(String key, Class<T> type) {
        Object o = this.metadata.get(key);
        if (o == null) {
            log.debug("Metadata key " + key + "does not exist");
            return null;
        }
        try {
            return type.cast(o);
        }
        catch (ClassCastException e) {
            log.debug("Error retrieving value for key " + key, (Throwable)e);
            return null;
        }
    }

    public static ImmutableMetadataBuilder builder() {
        return new ImmutableMetadataBuilder();
    }

    public static class ImmutableMetadataBuilder {
        private final Map<String, Object> metadata = new HashMap<String, Object>();

        private ImmutableMetadataBuilder() {
        }

        public ImmutableMetadataBuilder addString(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public ImmutableMetadataBuilder addInteger(String key, Integer value) {
            this.metadata.put(key, value);
            return this;
        }

        public ImmutableMetadataBuilder addLong(String key, Long value) {
            this.metadata.put(key, value);
            return this;
        }

        public ImmutableMetadataBuilder addFloat(String key, Float value) {
            this.metadata.put(key, value);
            return this;
        }

        public ImmutableMetadataBuilder addDouble(String key, Double value) {
            this.metadata.put(key, value);
            return this;
        }

        public ImmutableMetadataBuilder addBoolean(String key, Boolean value) {
            this.metadata.put(key, value);
            return this;
        }

        public ImmutableMetadata build() {
            return new ImmutableMetadata(this.metadata);
        }
    }
}

