/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Client;
import dev.openfeature.sdk.ClientMetadata;
import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventDetails;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.FeatureProviderStateManager;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.FlagEvaluationOptions;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookSupport;
import dev.openfeature.sdk.HookSupportData;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.OpenFeatureAPI;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.SharedHookContext;
import dev.openfeature.sdk.TrackingEventDetails;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ExceptionUtils;
import dev.openfeature.sdk.exceptions.FatalError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ProviderNotReadyError;
import dev.openfeature.sdk.internal.ObjectUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OpenFeatureClient
implements Client {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenFeatureClient.class);
    private final OpenFeatureAPI openfeatureApi;
    private final String domain;
    private final String version;
    private final ConcurrentLinkedQueue<Hook> clientHooks;
    private final AtomicReference<EvaluationContext> evaluationContext = new AtomicReference();
    private final HookSupport hookSupport;

    @Deprecated
    public OpenFeatureClient(OpenFeatureAPI openFeatureAPI, String domain, String version) {
        this.openfeatureApi = openFeatureAPI;
        this.domain = domain;
        this.version = version;
        this.hookSupport = new HookSupport();
        this.clientHooks = new ConcurrentLinkedQueue();
    }

    @Override
    public ProviderState getProviderState() {
        return this.openfeatureApi.getFeatureProviderStateManager(this.domain).getState();
    }

    @Override
    public void track(String trackingEventName) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        this.invokeTrack(trackingEventName, null, null);
    }

    @Override
    public void track(String trackingEventName, EvaluationContext context) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        Objects.requireNonNull(context);
        this.invokeTrack(trackingEventName, context, null);
    }

    @Override
    public void track(String trackingEventName, TrackingEventDetails details) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        Objects.requireNonNull(details);
        this.invokeTrack(trackingEventName, null, details);
    }

    @Override
    public void track(String trackingEventName, EvaluationContext context, TrackingEventDetails details) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        Objects.requireNonNull(context);
        Objects.requireNonNull(details);
        this.invokeTrack(trackingEventName, this.mergeEvaluationContext(context), details);
    }

    @Override
    public OpenFeatureClient addHooks(Hook ... hooks) {
        this.clientHooks.addAll(Arrays.asList(hooks));
        return this;
    }

    @Override
    public List<Hook> getHooks() {
        return new ArrayList<Hook>(this.clientHooks);
    }

    @Override
    public OpenFeatureClient setEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext.set(evaluationContext);
        return this;
    }

    @Override
    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="We don't want to allow any exception to reach the user. Instead, we return an evaluation result with the appropriate error code.")
    private <T> FlagEvaluationDetails<T> evaluateFlag(FlagValueType type, String key, T defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        FlagEvaluationDetails<Object> details = null;
        HookSupportData hookSupportData = new HookSupportData();
        FlagEvaluationOptions flagOptions = ObjectUtils.defaultIfNull(options, () -> FlagEvaluationOptions.builder().build());
        hookSupportData.hints = Collections.unmodifiableMap(flagOptions.getHookHints());
        try {
            FeatureProviderStateManager stateManager = this.openfeatureApi.getFeatureProviderStateManager(this.domain);
            FeatureProvider provider = stateManager.getProvider();
            ProviderState state = stateManager.getState();
            List<Hook> mergedHooks = ObjectUtils.merge(provider.getProviderHooks(), flagOptions.getHooks(), this.clientHooks, this.openfeatureApi.getMutableHooks());
            this.hookSupport.setHooks(hookSupportData, mergedHooks, type);
            SharedHookContext<T> sharedHookContext = new SharedHookContext<T>(key, type, this.getMetadata(), provider.getMetadata(), defaultValue);
            this.hookSupport.setHookContexts(hookSupportData, sharedHookContext);
            EvaluationContext evalContext = this.mergeEvaluationContext(ctx);
            this.hookSupport.updateEvaluationContext(hookSupportData, evalContext);
            this.hookSupport.executeBeforeHooks(hookSupportData);
            if (ProviderState.NOT_READY.equals((Object)state)) {
                throw new ProviderNotReadyError("Provider not yet initialized");
            }
            if (ProviderState.FATAL.equals((Object)state)) {
                throw new FatalError("Provider is in an irrecoverable error state");
            }
            ProviderEvaluation<?> providerEval = this.createProviderEvaluation(type, key, defaultValue, provider, hookSupportData.getEvaluationContext());
            details = FlagEvaluationDetails.from(providerEval, key);
            if (details.getErrorCode() != null) {
                OpenFeatureError error = ExceptionUtils.instantiateErrorByErrorCode(details.getErrorCode(), details.getErrorMessage());
                OpenFeatureClient.enrichDetailsWithErrorDefaults(defaultValue, details);
                this.hookSupport.executeErrorHooks(hookSupportData, error);
            } else {
                this.hookSupport.executeAfterHooks(hookSupportData, details);
            }
        }
        catch (Exception e) {
            if (details == null) {
                details = FlagEvaluationDetails.builder().flagKey(key).build();
            }
            if (e instanceof OpenFeatureError) {
                details.setErrorCode(((OpenFeatureError)e).getErrorCode());
            } else {
                details.setErrorCode(ErrorCode.GENERAL);
            }
            details.setErrorMessage(e.getMessage());
            OpenFeatureClient.enrichDetailsWithErrorDefaults(defaultValue, details);
            if (hookSupportData.getHooks() != null) {
                this.hookSupport.executeErrorHooks(hookSupportData, e);
            }
        }
        finally {
            if (hookSupportData.getHooks() != null) {
                this.hookSupport.executeAfterAllHooks(hookSupportData, details);
            }
        }
        return details;
    }

    private static <T> void enrichDetailsWithErrorDefaults(T defaultValue, FlagEvaluationDetails<T> details) {
        details.setValue(defaultValue);
        details.setReason(Reason.ERROR.toString());
    }

    private static void validateTrackingEventName(String str) {
        Objects.requireNonNull(str);
        if (str.isEmpty()) {
            throw new IllegalArgumentException("trackingEventName cannot be empty");
        }
    }

    private void invokeTrack(String trackingEventName, EvaluationContext context, TrackingEventDetails details) {
        this.openfeatureApi.getFeatureProviderStateManager(this.domain).getProvider().track(trackingEventName, this.mergeEvaluationContext(context), details);
    }

    private EvaluationContext mergeEvaluationContext(EvaluationContext invocationContext) {
        EvaluationContext apiContext = this.openfeatureApi.getEvaluationContext();
        EvaluationContext clientContext = this.evaluationContext.get();
        EvaluationContext transactionContext = this.openfeatureApi.getTransactionContext();
        return this.mergeContextMaps(apiContext, transactionContext, clientContext, invocationContext);
    }

    private EvaluationContext mergeContextMaps(EvaluationContext ... contexts) {
        HashMap<String, Value> merged = new HashMap<String, Value>();
        for (EvaluationContext evaluationContext : contexts) {
            if (evaluationContext == null || evaluationContext.isEmpty()) continue;
            EvaluationContext.mergeMaps(ImmutableStructure::new, merged, evaluationContext.asUnmodifiableMap());
        }
        return new ImmutableContext(merged);
    }

    private <T> ProviderEvaluation<?> createProviderEvaluation(FlagValueType type, String key, T defaultValue, FeatureProvider provider, EvaluationContext invocationContext) {
        switch (type) {
            case BOOLEAN: {
                return provider.getBooleanEvaluation(key, (Boolean)defaultValue, invocationContext);
            }
            case STRING: {
                return provider.getStringEvaluation(key, (String)defaultValue, invocationContext);
            }
            case INTEGER: {
                return provider.getIntegerEvaluation(key, (Integer)defaultValue, invocationContext);
            }
            case DOUBLE: {
                return provider.getDoubleEvaluation(key, (Double)defaultValue, invocationContext);
            }
            case OBJECT: {
                return provider.getObjectEvaluation(key, (Value)defaultValue, invocationContext);
            }
        }
        throw new GeneralError("Unknown flag type");
    }

    @Override
    public Boolean getBooleanValue(String key, Boolean defaultValue) {
        return this.getBooleanDetails(key, defaultValue).getValue();
    }

    @Override
    public Boolean getBooleanValue(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.getBooleanDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public Boolean getBooleanValue(String key, Boolean defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getBooleanDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Boolean> getBooleanDetails(String key, Boolean defaultValue) {
        return this.getBooleanDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Boolean> getBooleanDetails(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.getBooleanDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<Boolean> getBooleanDetails(String key, Boolean defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.BOOLEAN, key, defaultValue, ctx, options);
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
        return this.getStringDetails(key, defaultValue).getValue();
    }

    @Override
    public String getStringValue(String key, String defaultValue, EvaluationContext ctx) {
        return this.getStringDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public String getStringValue(String key, String defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getStringDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<String> getStringDetails(String key, String defaultValue) {
        return this.getStringDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<String> getStringDetails(String key, String defaultValue, EvaluationContext ctx) {
        return this.getStringDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<String> getStringDetails(String key, String defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.STRING, key, defaultValue, ctx, options);
    }

    @Override
    public Integer getIntegerValue(String key, Integer defaultValue) {
        return this.getIntegerDetails(key, defaultValue).getValue();
    }

    @Override
    public Integer getIntegerValue(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.getIntegerDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public Integer getIntegerValue(String key, Integer defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getIntegerDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Integer> getIntegerDetails(String key, Integer defaultValue) {
        return this.getIntegerDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Integer> getIntegerDetails(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.getIntegerDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<Integer> getIntegerDetails(String key, Integer defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.INTEGER, key, defaultValue, ctx, options);
    }

    @Override
    public Double getDoubleValue(String key, Double defaultValue) {
        return this.getDoubleValue(key, defaultValue, null);
    }

    @Override
    public Double getDoubleValue(String key, Double defaultValue, EvaluationContext ctx) {
        return this.getDoubleValue(key, defaultValue, ctx, null);
    }

    @Override
    public Double getDoubleValue(String key, Double defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.DOUBLE, key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Double> getDoubleDetails(String key, Double defaultValue) {
        return this.getDoubleDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Double> getDoubleDetails(String key, Double defaultValue, EvaluationContext ctx) {
        return this.getDoubleDetails(key, defaultValue, ctx, null);
    }

    @Override
    public FlagEvaluationDetails<Double> getDoubleDetails(String key, Double defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.DOUBLE, key, defaultValue, ctx, options);
    }

    @Override
    public Value getObjectValue(String key, Value defaultValue) {
        return this.getObjectDetails(key, defaultValue).getValue();
    }

    @Override
    public Value getObjectValue(String key, Value defaultValue, EvaluationContext ctx) {
        return this.getObjectDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public Value getObjectValue(String key, Value defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getObjectDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Value> getObjectDetails(String key, Value defaultValue) {
        return this.getObjectDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Value> getObjectDetails(String key, Value defaultValue, EvaluationContext ctx) {
        return this.getObjectDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<Value> getObjectDetails(String key, Value defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.OBJECT, key, defaultValue, ctx, options);
    }

    @Override
    public ClientMetadata getMetadata() {
        return () -> this.domain;
    }

    @Override
    public Client onProviderReady(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_READY, (Consumer)handler);
    }

    @Override
    public Client onProviderConfigurationChanged(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, (Consumer)handler);
    }

    @Override
    public Client onProviderError(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_ERROR, (Consumer)handler);
    }

    @Override
    public Client onProviderStale(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_STALE, (Consumer)handler);
    }

    @Override
    public Client on(ProviderEvent event, Consumer<EventDetails> handler) {
        this.openfeatureApi.addHandler(this.domain, event, handler);
        return this;
    }

    @Override
    public Client removeHandler(ProviderEvent event, Consumer<EventDetails> handler) {
        this.openfeatureApi.removeHandler(this.domain, event, handler);
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDomain() {
        return this.domain;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getVersion() {
        return this.version;
    }
}

