/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.Client;
import dev.openfeature.sdk.ClientMetadata;
import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventDetails;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.FeatureProviderStateManager;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.FlagEvaluationOptions;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookContext;
import dev.openfeature.sdk.HookSupport;
import dev.openfeature.sdk.ImmutableContext;
import dev.openfeature.sdk.ImmutableStructure;
import dev.openfeature.sdk.OpenFeatureAPI;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.ProviderEvent;
import dev.openfeature.sdk.ProviderState;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.TrackingEventDetails;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ExceptionUtils;
import dev.openfeature.sdk.exceptions.FatalError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ProviderNotReadyError;
import dev.openfeature.sdk.internal.AutoCloseableLock;
import dev.openfeature.sdk.internal.AutoCloseableReentrantReadWriteLock;
import dev.openfeature.sdk.internal.ObjectUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OpenFeatureClient
implements Client {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenFeatureClient.class);
    private final OpenFeatureAPI openfeatureApi;
    private final String domain;
    private final String version;
    private final List<Hook> clientHooks;
    private final HookSupport hookSupport;
    AutoCloseableReentrantReadWriteLock hooksLock = new AutoCloseableReentrantReadWriteLock();
    AutoCloseableReentrantReadWriteLock contextLock = new AutoCloseableReentrantReadWriteLock();
    private EvaluationContext evaluationContext;

    @Deprecated
    public OpenFeatureClient(OpenFeatureAPI openFeatureAPI, String domain, String version) {
        this.openfeatureApi = openFeatureAPI;
        this.domain = domain;
        this.version = version;
        this.clientHooks = new ArrayList<Hook>();
        this.hookSupport = new HookSupport();
    }

    @Override
    public ProviderState getProviderState() {
        return this.openfeatureApi.getFeatureProviderStateManager(this.domain).getState();
    }

    @Override
    public void track(String trackingEventName) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        this.invokeTrack(trackingEventName, null, null);
    }

    @Override
    public void track(String trackingEventName, EvaluationContext context) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        Objects.requireNonNull(context);
        this.invokeTrack(trackingEventName, context, null);
    }

    @Override
    public void track(String trackingEventName, TrackingEventDetails details) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        Objects.requireNonNull(details);
        this.invokeTrack(trackingEventName, null, details);
    }

    @Override
    public void track(String trackingEventName, EvaluationContext context, TrackingEventDetails details) {
        OpenFeatureClient.validateTrackingEventName(trackingEventName);
        Objects.requireNonNull(context);
        Objects.requireNonNull(details);
        this.invokeTrack(trackingEventName, this.mergeEvaluationContext(context), details);
    }

    @Override
    public OpenFeatureClient addHooks(Hook ... hooks) {
        try (AutoCloseableLock __ = this.hooksLock.writeLockAutoCloseable();){
            this.clientHooks.addAll(Arrays.asList(hooks));
        }
        return this;
    }

    @Override
    public List<Hook> getHooks() {
        try (AutoCloseableLock __ = this.hooksLock.readLockAutoCloseable();){
            List<Hook> list = this.clientHooks;
            return list;
        }
    }

    @Override
    public OpenFeatureClient setEvaluationContext(EvaluationContext evaluationContext) {
        try (AutoCloseableLock __ = this.contextLock.writeLockAutoCloseable();){
            this.evaluationContext = evaluationContext;
        }
        return this;
    }

    @Override
    public EvaluationContext getEvaluationContext() {
        try (AutoCloseableLock __ = this.contextLock.readLockAutoCloseable();){
            EvaluationContext evaluationContext = this.evaluationContext;
            return evaluationContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> FlagEvaluationDetails<T> evaluateFlag(FlagValueType type, String key, T defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        FlagEvaluationOptions flagOptions = ObjectUtils.defaultIfNull(options, () -> FlagEvaluationOptions.builder().build());
        Map<String, Object> hints = Collections.unmodifiableMap(flagOptions.getHookHints());
        FlagEvaluationDetails<Object> details = null;
        List<Hook> mergedHooks = null;
        HookContext<T> afterHookContext = null;
        try {
            FeatureProviderStateManager stateManager = this.openfeatureApi.getFeatureProviderStateManager(this.domain);
            FeatureProvider provider = stateManager.getProvider();
            ProviderState state = stateManager.getState();
            if (ProviderState.NOT_READY.equals((Object)state)) {
                throw new ProviderNotReadyError("provider not yet initialized");
            }
            if (ProviderState.FATAL.equals((Object)state)) {
                throw new FatalError("provider is in an irrecoverable error state");
            }
            mergedHooks = ObjectUtils.merge(provider.getProviderHooks(), flagOptions.getHooks(), this.clientHooks, this.openfeatureApi.getHooks());
            EvaluationContext mergedCtx = this.hookSupport.beforeHooks(type, HookContext.from(key, type, this.getMetadata(), provider.getMetadata(), this.mergeEvaluationContext(ctx), defaultValue), mergedHooks, hints);
            afterHookContext = HookContext.from(key, type, this.getMetadata(), provider.getMetadata(), mergedCtx, defaultValue);
            ProviderEvaluation<?> providerEval = this.createProviderEvaluation(type, key, defaultValue, provider, mergedCtx);
            details = FlagEvaluationDetails.from(providerEval, key);
            if (details.getErrorCode() != null) {
                OpenFeatureError error = ExceptionUtils.instantiateErrorByErrorCode(details.getErrorCode(), details.getErrorMessage());
                OpenFeatureClient.enrichDetailsWithErrorDefaults(defaultValue, details);
                this.hookSupport.errorHooks(type, afterHookContext, error, mergedHooks, hints);
            } else {
                this.hookSupport.afterHooks(type, afterHookContext, details, mergedHooks, hints);
            }
        }
        catch (Exception e) {
            if (details == null) {
                details = FlagEvaluationDetails.builder().build();
            }
            if (e instanceof OpenFeatureError) {
                details.setErrorCode(((OpenFeatureError)e).getErrorCode());
            } else {
                details.setErrorCode(ErrorCode.GENERAL);
            }
            details.setErrorMessage(e.getMessage());
            OpenFeatureClient.enrichDetailsWithErrorDefaults(defaultValue, details);
            this.hookSupport.errorHooks(type, afterHookContext, e, mergedHooks, hints);
        }
        finally {
            this.hookSupport.afterAllHooks(type, afterHookContext, details, mergedHooks, hints);
        }
        return details;
    }

    private static <T> void enrichDetailsWithErrorDefaults(T defaultValue, FlagEvaluationDetails<T> details) {
        details.setValue(defaultValue);
        details.setReason(Reason.ERROR.toString());
    }

    private static void validateTrackingEventName(String str) {
        Objects.requireNonNull(str);
        if (str.isEmpty()) {
            throw new IllegalArgumentException("trackingEventName cannot be empty");
        }
    }

    private void invokeTrack(String trackingEventName, EvaluationContext context, TrackingEventDetails details) {
        this.openfeatureApi.getFeatureProviderStateManager(this.domain).getProvider().track(trackingEventName, this.mergeEvaluationContext(context), details);
    }

    private EvaluationContext mergeEvaluationContext(EvaluationContext invocationContext) {
        EvaluationContext apiContext = this.openfeatureApi.getEvaluationContext();
        EvaluationContext clientContext = this.getEvaluationContext();
        EvaluationContext transactionContext = this.openfeatureApi.getTransactionContext();
        return this.mergeContextMaps(apiContext, transactionContext, clientContext, invocationContext);
    }

    private EvaluationContext mergeContextMaps(EvaluationContext ... contexts) {
        HashMap<String, Value> merged = new HashMap<String, Value>();
        for (EvaluationContext evaluationContext : contexts) {
            if (evaluationContext == null || evaluationContext.isEmpty()) continue;
            EvaluationContext.mergeMaps(ImmutableStructure::new, merged, evaluationContext.asUnmodifiableMap());
        }
        return new ImmutableContext(merged);
    }

    private <T> ProviderEvaluation<?> createProviderEvaluation(FlagValueType type, String key, T defaultValue, FeatureProvider provider, EvaluationContext invocationContext) {
        switch (type) {
            case BOOLEAN: {
                return provider.getBooleanEvaluation(key, (Boolean)defaultValue, invocationContext);
            }
            case STRING: {
                return provider.getStringEvaluation(key, (String)defaultValue, invocationContext);
            }
            case INTEGER: {
                return provider.getIntegerEvaluation(key, (Integer)defaultValue, invocationContext);
            }
            case DOUBLE: {
                return provider.getDoubleEvaluation(key, (Double)defaultValue, invocationContext);
            }
            case OBJECT: {
                return provider.getObjectEvaluation(key, (Value)defaultValue, invocationContext);
            }
        }
        throw new GeneralError("Unknown flag type");
    }

    @Override
    public Boolean getBooleanValue(String key, Boolean defaultValue) {
        return this.getBooleanDetails(key, defaultValue).getValue();
    }

    @Override
    public Boolean getBooleanValue(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.getBooleanDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public Boolean getBooleanValue(String key, Boolean defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getBooleanDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Boolean> getBooleanDetails(String key, Boolean defaultValue) {
        return this.getBooleanDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Boolean> getBooleanDetails(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.getBooleanDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<Boolean> getBooleanDetails(String key, Boolean defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.BOOLEAN, key, defaultValue, ctx, options);
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
        return this.getStringDetails(key, defaultValue).getValue();
    }

    @Override
    public String getStringValue(String key, String defaultValue, EvaluationContext ctx) {
        return this.getStringDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public String getStringValue(String key, String defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getStringDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<String> getStringDetails(String key, String defaultValue) {
        return this.getStringDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<String> getStringDetails(String key, String defaultValue, EvaluationContext ctx) {
        return this.getStringDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<String> getStringDetails(String key, String defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.STRING, key, defaultValue, ctx, options);
    }

    @Override
    public Integer getIntegerValue(String key, Integer defaultValue) {
        return this.getIntegerDetails(key, defaultValue).getValue();
    }

    @Override
    public Integer getIntegerValue(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.getIntegerDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public Integer getIntegerValue(String key, Integer defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getIntegerDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Integer> getIntegerDetails(String key, Integer defaultValue) {
        return this.getIntegerDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Integer> getIntegerDetails(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.getIntegerDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<Integer> getIntegerDetails(String key, Integer defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.INTEGER, key, defaultValue, ctx, options);
    }

    @Override
    public Double getDoubleValue(String key, Double defaultValue) {
        return this.getDoubleValue(key, defaultValue, null);
    }

    @Override
    public Double getDoubleValue(String key, Double defaultValue, EvaluationContext ctx) {
        return this.getDoubleValue(key, defaultValue, ctx, null);
    }

    @Override
    public Double getDoubleValue(String key, Double defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.DOUBLE, key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Double> getDoubleDetails(String key, Double defaultValue) {
        return this.getDoubleDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Double> getDoubleDetails(String key, Double defaultValue, EvaluationContext ctx) {
        return this.getDoubleDetails(key, defaultValue, ctx, null);
    }

    @Override
    public FlagEvaluationDetails<Double> getDoubleDetails(String key, Double defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.DOUBLE, key, defaultValue, ctx, options);
    }

    @Override
    public Value getObjectValue(String key, Value defaultValue) {
        return this.getObjectDetails(key, defaultValue).getValue();
    }

    @Override
    public Value getObjectValue(String key, Value defaultValue, EvaluationContext ctx) {
        return this.getObjectDetails(key, defaultValue, ctx).getValue();
    }

    @Override
    public Value getObjectValue(String key, Value defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.getObjectDetails(key, defaultValue, ctx, options).getValue();
    }

    @Override
    public FlagEvaluationDetails<Value> getObjectDetails(String key, Value defaultValue) {
        return this.getObjectDetails(key, defaultValue, null);
    }

    @Override
    public FlagEvaluationDetails<Value> getObjectDetails(String key, Value defaultValue, EvaluationContext ctx) {
        return this.getObjectDetails(key, defaultValue, ctx, FlagEvaluationOptions.builder().build());
    }

    @Override
    public FlagEvaluationDetails<Value> getObjectDetails(String key, Value defaultValue, EvaluationContext ctx, FlagEvaluationOptions options) {
        return this.evaluateFlag(FlagValueType.OBJECT, key, defaultValue, ctx, options);
    }

    @Override
    public ClientMetadata getMetadata() {
        return () -> this.domain;
    }

    @Override
    public Client onProviderReady(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_READY, (Consumer)handler);
    }

    @Override
    public Client onProviderConfigurationChanged(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_CONFIGURATION_CHANGED, (Consumer)handler);
    }

    @Override
    public Client onProviderError(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_ERROR, (Consumer)handler);
    }

    @Override
    public Client onProviderStale(Consumer<EventDetails> handler) {
        return this.on(ProviderEvent.PROVIDER_STALE, (Consumer)handler);
    }

    @Override
    public Client on(ProviderEvent event, Consumer<EventDetails> handler) {
        OpenFeatureAPI.getInstance().addHandler(this.domain, event, handler);
        return this;
    }

    @Override
    public Client removeHandler(ProviderEvent event, Consumer<EventDetails> handler) {
        OpenFeatureAPI.getInstance().removeHandler(this.domain, event, handler);
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDomain() {
        return this.domain;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getVersion() {
        return this.version;
    }
}

