/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk.exceptions;

import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.exceptions.FlagNotFoundError;
import dev.openfeature.sdk.exceptions.GeneralError;
import dev.openfeature.sdk.exceptions.InvalidContextError;
import dev.openfeature.sdk.exceptions.OpenFeatureError;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.ProviderNotReadyError;
import dev.openfeature.sdk.exceptions.TargetingKeyMissingError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public final class ExceptionUtils {
    public static OpenFeatureError instantiateErrorByErrorCode(ErrorCode errorCode, String errorMessage) {
        switch (errorCode) {
            case FLAG_NOT_FOUND: {
                return new FlagNotFoundError(errorMessage);
            }
            case PARSE_ERROR: {
                return new ParseError(errorMessage);
            }
            case TYPE_MISMATCH: {
                return new TypeMismatchError(errorMessage);
            }
            case TARGETING_KEY_MISSING: {
                return new TargetingKeyMissingError(errorMessage);
            }
            case INVALID_CONTEXT: {
                return new InvalidContextError(errorMessage);
            }
            case PROVIDER_NOT_READY: {
                return new ProviderNotReadyError(errorMessage);
            }
        }
        return new GeneralError(errorMessage);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ExceptionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

