/*
 * Decompiled with CFR 0.152.
 */
package dev.mythicdrops.gradle.spigot;

import dev.mythicdrops.gradle.spigot.SyncTaskBuildService;
import java.io.File;
import java.nio.file.Paths;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\"\u001a\u00020#H\u0007J\u0018\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010'\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006("}, d2={"Ldev/mythicdrops/gradle/spigot/RunSpigotBuildToolsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "syncTask", "Lorg/gradle/api/provider/Property;", "Ldev/mythicdrops/gradle/spigot/SyncTaskBuildService;", "getSyncTask", "()Lorg/gradle/api/provider/Property;", "buildToolsLocation", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildToolsLocation", "()Lorg/gradle/api/file/RegularFileProperty;", "includeRemapped", "", "getIncludeRemapped", "version", "", "getVersion", "launcher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "getLauncher", "execOperations", "Lorg/gradle/process/ExecOperations;", "getExecOperations", "()Lorg/gradle/process/ExecOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "getFileSystemOperations", "()Lorg/gradle/api/file/FileSystemOperations;", "javaToolchainService", "Lorg/gradle/jvm/toolchain/JavaToolchainService;", "getJavaToolchainService", "()Lorg/gradle/jvm/toolchain/JavaToolchainService;", "runSpigotBuildTools", "", "normalVersion", "mavenLocalDirectory", "Ljava/io/File;", "remappedVersion", "mythicdrops-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRunSpigotBuildToolsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunSpigotBuildToolsTask.kt\ndev/mythicdrops/gradle/spigot/RunSpigotBuildToolsTask\n+ 2 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 3 TypeOfExtensions.kt\norg/gradle/kotlin/dsl/TypeOfExtensionsKt\n*L\n1#1,129:1\n110#2:130\n28#3:131\n*S KotlinDebug\n*F\n+ 1 RunSpigotBuildToolsTask.kt\ndev/mythicdrops/gradle/spigot/RunSpigotBuildToolsTask\n*L\n50#1:130\n50#1:131\n*E\n"})
public abstract class RunSpigotBuildToolsTask
extends DefaultTask {
    public RunSpigotBuildToolsTask() {
        this.setDescription("Runs Spigot BuildTools.jar for a specific Minecraft version");
        this.setGroup("spigot");
        ExtensionContainer extensionContainer = this.getProject().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
        ExtensionContainer $this$getByType$iv = extensionContainer;
        boolean $i$f$getByType = false;
        boolean $i$f$typeOf = false;
        Object object = $this$getByType$iv.getByType((TypeOf)new TypeOf<JavaPluginExtension>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(typeOf<T>())");
        JavaToolchainSpec javaToolchainSpec = ((JavaPluginExtension)object).getToolchain();
        Intrinsics.checkNotNullExpressionValue((Object)javaToolchainSpec, (String)"getToolchain(...)");
        JavaToolchainSpec toolchain = javaToolchainSpec;
        Provider provider = this.getJavaToolchainService().launcherFor(toolchain);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"launcherFor(...)");
        Provider defaultLauncher = provider;
        this.getLauncher().convention(defaultLauncher);
    }

    @ServiceReference(value="mythicDropsSyncTask")
    @NotNull
    public abstract Property<SyncTaskBuildService> getSyncTask();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildToolsLocation();

    @Input
    @NotNull
    public abstract Property<Boolean> getIncludeRemapped();

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Nested
    @NotNull
    public abstract Property<JavaLauncher> getLauncher();

    @Inject
    @NotNull
    public abstract ExecOperations getExecOperations();

    @Inject
    @NotNull
    public abstract FileSystemOperations getFileSystemOperations();

    @Inject
    @NotNull
    public abstract JavaToolchainService getJavaToolchainService();

    @TaskAction
    public final void runSpigotBuildTools() {
        Object object = this.getVersion().getOrElse((Object)"");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        String version = (String)object;
        if (StringsKt.isBlank((CharSequence)version)) {
            this.getLogger().lifecycle("Not running Spigot build tools as the version is blank");
            return;
        }
        File mavenLocalDirectory = Paths.get(this.getProject().getRepositories().mavenLocal().getUrl()).toFile();
        if (!mavenLocalDirectory.exists()) {
            this.getLogger().lifecycle("Creating Maven Local repository at " + mavenLocalDirectory.getAbsolutePath());
            mavenLocalDirectory.mkdirs();
        }
        Intrinsics.checkNotNull((Object)mavenLocalDirectory);
        this.normalVersion(mavenLocalDirectory, version);
        if (((Boolean)this.getIncludeRemapped().getOrElse((Object)false)).booleanValue()) {
            this.remappedVersion(mavenLocalDirectory, version);
        }
    }

    private final void normalVersion(File mavenLocalDirectory, String version) {
        File versionJar = FilesKt.resolve((File)mavenLocalDirectory, (String)("org/spigotmc/spigot/" + version + "-R0.1-SNAPSHOT/spigot-" + version + "-R0.1-SNAPSHOT.jar"));
        if (versionJar.exists()) {
            this.getLogger().lifecycle("Skipping " + version + " as Spigot JAR is found at " + versionJar.getAbsolutePath());
            return;
        }
        File file = ((RegularFile)this.getBuildToolsLocation().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        File jar = file;
        File file2 = jar.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        File versionDir = FilesKt.resolve((File)file2, (String)version);
        Function1 function1 = (Function1)new Function1<CopySpec, Unit>(jar, versionDir){
            final /* synthetic */ File $jar;
            final /* synthetic */ File $versionDir;
            {
                this.$jar = $jar;
                this.$versionDir = $versionDir;
                super(1);
            }

            public final void invoke(@NotNull CopySpec $this$copy) {
                Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
                Object[] objectArray = new Object[]{this.$jar};
                $this$copy.from(objectArray);
                $this$copy.into((Object)this.$versionDir);
            }
        };
        this.getFileSystemOperations().copy(new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        function1 = (Function1)new Function1<JavaExecSpec, Unit>(version, versionDir, this){
            final /* synthetic */ String $version;
            final /* synthetic */ File $versionDir;
            final /* synthetic */ RunSpigotBuildToolsTask this$0;
            {
                this.$version = $version;
                this.$versionDir = $versionDir;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JavaExecSpec $this$javaexec) {
                Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                Object[] objectArray = new String[]{"--rev", this.$version};
                $this$javaexec.args((Iterable)CollectionsKt.listOf((Object[])objectArray));
                $this$javaexec.setWorkingDir(this.$versionDir.getAbsoluteFile());
                $this$javaexec.setJvmArgs(CollectionsKt.listOf((Object)"-Xmx1024M"));
                objectArray = new Object[]{this.this$0.getBuildToolsLocation()};
                $this$javaexec.classpath(objectArray);
                $this$javaexec.executable((Object)((JavaLauncher)this.this$0.getLauncher().get()).getExecutablePath());
            }
        };
        this.getExecOperations().javaexec(new /* invalid duplicate definition of identical inner class */);
    }

    private final void remappedVersion(File mavenLocalDirectory, String version) {
        File versionJar = FilesKt.resolve((File)mavenLocalDirectory, (String)("org/spigotmc/spigot/" + version + "-R0.1-SNAPSHOT/spigot-" + version + "-R0.1-SNAPSHOT-remapped-mojang.jar"));
        if (versionJar.exists()) {
            this.getLogger().lifecycle("Skipping " + version + " as Spigot remapped JAR is found at " + versionJar.getAbsolutePath());
            return;
        }
        File file = ((RegularFile)this.getBuildToolsLocation().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        File jar = file;
        File file2 = jar.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        File versionDir = FilesKt.resolve((File)file2, (String)version);
        Function1 function1 = (Function1)new Function1<CopySpec, Unit>(jar, versionDir){
            final /* synthetic */ File $jar;
            final /* synthetic */ File $versionDir;
            {
                this.$jar = $jar;
                this.$versionDir = $versionDir;
                super(1);
            }

            public final void invoke(@NotNull CopySpec $this$copy) {
                Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
                Object[] objectArray = new Object[]{this.$jar};
                $this$copy.from(objectArray);
                $this$copy.into((Object)this.$versionDir);
            }
        };
        this.getFileSystemOperations().copy(new /* invalid duplicate definition of identical inner class */);
        function1 = (Function1)new Function1<JavaExecSpec, Unit>(version, versionDir, this){
            final /* synthetic */ String $version;
            final /* synthetic */ File $versionDir;
            final /* synthetic */ RunSpigotBuildToolsTask this$0;
            {
                this.$version = $version;
                this.$versionDir = $versionDir;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JavaExecSpec $this$javaexec) {
                Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                Object[] objectArray = new String[]{"--rev", this.$version, "--remapped"};
                $this$javaexec.args((Iterable)CollectionsKt.listOf((Object[])objectArray));
                $this$javaexec.setWorkingDir(this.$versionDir.getAbsoluteFile());
                $this$javaexec.setJvmArgs(CollectionsKt.listOf((Object)"-Xmx1024M"));
                objectArray = new Object[]{this.this$0.getBuildToolsLocation()};
                $this$javaexec.classpath(objectArray);
                $this$javaexec.executable((Object)((JavaLauncher)this.this$0.getLauncher().get()).getExecutablePath());
            }
        };
        this.getExecOperations().javaexec(new /* invalid duplicate definition of identical inner class */);
    }
}

