/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l2;

import dev.ludovic.netlib.benchmarks.blas.l2.L2Benchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class Sspr2Benchmark
extends L2Benchmark {
    @Param(value={"U", "L"})
    public String uplo;
    @Param(value={"10", "1000"})
    public int n;
    public float alpha;
    public float[] a;
    public float[] aclone;
    public float[] x;
    public float[] y;

    public Sspr2Benchmark() {
        this.aclone = (float[])this.a.clone();
    }

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomFloat();
        this.a = this.randomFloatArray(this.n * (this.n + 1) / 2);
        this.x = this.randomFloatArray(this.n);
        this.y = this.randomFloatArray(this.n);
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.aclone = (float[])this.a.clone();
        this.blas.sspr2(this.uplo, this.n, this.alpha, this.x, 1, this.y, 1, this.aclone);
        bh.consume((Object)this.aclone);
    }
}

