/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.arpack;

import dev.ludovic.netlib.ARPACK;
import dev.ludovic.netlib.JavaARPACK;
import dev.ludovic.netlib.NativeARPACK;
import dev.ludovic.netlib.arpack.NetlibF2jARPACK;
import java.util.Random;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Thread)
public abstract class ARPACKBenchmark {
    public ARPACK arpack;
    @Param(value={"f2j", "java", "native"})
    public String implementation;
    private final Random rand = new Random(0L);

    @Setup
    public void setupImplementation() {
        switch (this.implementation) {
            case "f2j": {
                this.arpack = NetlibF2jARPACK.getInstance();
                break;
            }
            case "java": {
                this.arpack = JavaARPACK.getInstance();
                break;
            }
            case "native": {
                this.arpack = NativeARPACK.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown implementation = " + this.implementation);
            }
        }
    }

    protected double randomDouble() {
        return this.rand.nextDouble();
    }

    protected double[] randomDoubleArray(int n) {
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextDouble();
        }
        return res;
    }

    protected float randomFloat() {
        return this.rand.nextFloat();
    }

    protected float[] randomFloatArray(int n) {
        float[] res = new float[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextFloat();
        }
        return res;
    }
}

