/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.workersai.client;

import dev.langchain4j.model.workersai.client.WorkersAiApi;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class WorkersAiClient {
    private static final String BASE_URL = "https://api.cloudflare.com/";

    public static WorkersAiApi createService(String apiToken) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthInterceptor(apiToken)).callTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(30L)).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        return (WorkersAiApi)retrofit.create(WorkersAiApi.class);
    }

    public static class AuthInterceptor
    implements Interceptor {
        private final String apiToken;

        public AuthInterceptor(String apiToken) {
            this.apiToken = apiToken;
        }

        @NotNull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder builder = chain.request().newBuilder().header("Authorization", "Bearer " + this.apiToken);
            Request request = builder.build();
            return chain.proceed(request);
        }
    }
}

