/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.workersai;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.workersai.client.AbstractWorkersAIModel;
import dev.langchain4j.model.workersai.client.ApiResponse;
import dev.langchain4j.model.workersai.client.WorkersAiTextCompletionRequest;
import dev.langchain4j.model.workersai.client.WorkersAiTextCompletionResponse;
import dev.langchain4j.model.workersai.spi.WorkersAiLanguageModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.io.IOException;
import java.util.Iterator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkersAiLanguageModel
extends AbstractWorkersAIModel
implements LanguageModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkersAiLanguageModel.class);

    public WorkersAiLanguageModel(Builder builder) {
        this(builder.accountId, builder.modelName, builder.apiToken);
    }

    public WorkersAiLanguageModel(String accountId, String modelName, String apiToken) {
        super(accountId, modelName, apiToken);
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(WorkersAiLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            WorkersAiLanguageModelBuilderFactory factory = (WorkersAiLanguageModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public Response<String> generate(String prompt) {
        try {
            retrofit2.Response retrofitResponse = this.workerAiClient.generateText(new WorkersAiTextCompletionRequest(prompt), this.accountId, this.modelName).execute();
            this.processErrors((ApiResponse)retrofitResponse.body(), retrofitResponse.errorBody());
            if (retrofitResponse.body() == null) {
                throw new RuntimeException("Empty response");
            }
            return new Response((Object)((WorkersAiTextCompletionResponse.TextResponse)((WorkersAiTextCompletionResponse)retrofitResponse.body()).getResult()).getResponse());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<String> generate(Prompt prompt) {
        return this.generate(prompt.text());
    }

    public static class Builder {
        public String accountId;
        public String apiToken;
        public String modelName;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder apiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public WorkersAiLanguageModel build() {
            return new WorkersAiLanguageModel(this);
        }
    }
}

