/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.workersai;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ChatRequestValidator;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.workersai.client.AbstractWorkersAIModel;
import dev.langchain4j.model.workersai.client.ApiResponse;
import dev.langchain4j.model.workersai.client.WorkersAiChatCompletionRequest;
import dev.langchain4j.model.workersai.client.WorkersAiChatCompletionResponse;
import dev.langchain4j.model.workersai.client.WorkersAiTextCompletionResponse;
import dev.langchain4j.model.workersai.spi.WorkersAiChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkersAiChatModel
extends AbstractWorkersAIModel
implements ChatLanguageModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkersAiChatModel.class);

    public WorkersAiChatModel(Builder builder) {
        this(builder.accountId, builder.modelName, builder.apiToken);
    }

    public WorkersAiChatModel(String accountId, String modelName, String apiToken) {
        super(accountId, modelName, apiToken);
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(WorkersAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            WorkersAiChatModelBuilderFactory factory = (WorkersAiChatModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequestValidator.validateMessages((List)chatRequest.messages());
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidator.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidator.validate((List)parameters.toolSpecifications());
        ChatRequestValidator.validate((ToolChoice)parameters.toolChoice());
        ChatRequestValidator.validate((ResponseFormat)parameters.responseFormat());
        Response<AiMessage> response = this.generate(chatRequest.messages());
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    private Response<AiMessage> generate(List<ChatMessage> messages) {
        WorkersAiChatCompletionRequest req = new WorkersAiChatCompletionRequest();
        req.setMessages(messages.stream().map(this::toMessage).collect(Collectors.toList()));
        return new Response((Object)new AiMessage(this.generate(req)), null, FinishReason.STOP);
    }

    private WorkersAiChatCompletionRequest.Message toMessage(ChatMessage message) {
        return new WorkersAiChatCompletionRequest.Message(WorkersAiChatCompletionRequest.MessageRole.valueOf(message.type().name().toLowerCase()), message.text());
    }

    private String generate(WorkersAiChatCompletionRequest req) {
        try {
            retrofit2.Response retrofitResponse = this.workerAiClient.generateChat(req, this.accountId, this.modelName).execute();
            this.processErrors((ApiResponse)retrofitResponse.body(), retrofitResponse.errorBody());
            if (retrofitResponse.body() == null) {
                throw new IllegalStateException("Response is empty");
            }
            return ((WorkersAiTextCompletionResponse.TextResponse)((WorkersAiChatCompletionResponse)retrofitResponse.body()).getResult()).getResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        public String accountId;
        public String apiToken;
        public String modelName;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder apiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public WorkersAiChatModel build() {
            return new WorkersAiChatModel(this);
        }
    }
}

