/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.workersai;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.workersai.client.AbstractWorkersAIModel;
import dev.langchain4j.model.workersai.client.ApiResponse;
import dev.langchain4j.model.workersai.client.WorkersAiChatCompletionRequest;
import dev.langchain4j.model.workersai.client.WorkersAiChatCompletionResponse;
import dev.langchain4j.model.workersai.client.WorkersAiTextCompletionResponse;
import dev.langchain4j.model.workersai.spi.WorkersAiChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkersAiChatModel
extends AbstractWorkersAIModel
implements ChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(WorkersAiChatModel.class);

    public WorkersAiChatModel(Builder builder) {
        this(builder.accountId, builder.modelName, builder.apiToken);
    }

    public WorkersAiChatModel(String accountId, String modelName, String apiToken) {
        super(accountId, modelName, apiToken);
    }

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(WorkersAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            WorkersAiChatModelBuilderFactory factory = (WorkersAiChatModelBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return new Builder();
    }

    public String generate(String userMessage) {
        return this.generate(new WorkersAiChatCompletionRequest(WorkersAiChatCompletionRequest.MessageRole.user, userMessage));
    }

    public Response<AiMessage> generate(ChatMessage ... messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        return this.generate(Arrays.asList(messages));
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        WorkersAiChatCompletionRequest req = new WorkersAiChatCompletionRequest();
        req.setMessages(messages.stream().map(this::toMessage).collect(Collectors.toList()));
        return new Response((Object)new AiMessage(this.generate(req)), null, FinishReason.STOP);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        throw new UnsupportedOperationException("Tools are currently not supported for WorkerAI models");
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        throw new UnsupportedOperationException("Tools are currently not supported for WorkerAI models");
    }

    private WorkersAiChatCompletionRequest.Message toMessage(ChatMessage message) {
        return new WorkersAiChatCompletionRequest.Message(WorkersAiChatCompletionRequest.MessageRole.valueOf(message.type().name().toLowerCase()), message.text());
    }

    private String generate(WorkersAiChatCompletionRequest req) {
        try {
            retrofit2.Response retrofitResponse = this.workerAiClient.generateChat(req, this.accountId, this.modelName).execute();
            this.processErrors((ApiResponse)retrofitResponse.body(), retrofitResponse.errorBody());
            if (retrofitResponse.body() == null) {
                throw new IllegalStateException("Response is empty");
            }
            return ((WorkersAiTextCompletionResponse.TextResponse)((WorkersAiChatCompletionResponse)retrofitResponse.body()).getResult()).getResponse();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        public String accountId;
        public String apiToken;
        public String modelName;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder apiToken(String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public WorkersAiChatModel build() {
            return new WorkersAiChatModel(this);
        }
    }
}

