/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.workersai.client;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.workersai.client.ApiResponse;
import dev.langchain4j.model.workersai.client.WorkersAiApi;
import dev.langchain4j.model.workersai.client.WorkersAiClient;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkersAIModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkersAIModel.class);
    protected String accountId;
    protected String modelName;
    protected WorkersAiApi workerAiClient;

    public AbstractWorkersAIModel(String accountId, String modelName, String apiToken) {
        ValidationUtils.ensureNotEmpty((String)accountId, (String)"%s", (Object[])new Object[]{"Account identifier should not be null or empty"});
        this.accountId = accountId;
        ValidationUtils.ensureNotEmpty((String)modelName, (String)"%s", (Object[])new Object[]{"Model name should not be null or empty"});
        this.modelName = modelName;
        ValidationUtils.ensureNotEmpty((String)apiToken, (String)"%s", (Object[])new Object[]{"Token should not be null or empty"});
        this.workerAiClient = WorkersAiClient.createService(apiToken);
    }

    protected void processErrors(ApiResponse<?> res, ResponseBody errors) throws IOException {
        if (res == null || !res.isSuccess()) {
            StringBuilder errorMessage = new StringBuilder("Failed to generate chat message:");
            if (res == null) {
                errorMessage.append(errors.string());
            } else if (res.getErrors() != null) {
                errorMessage.append(res.getErrors().stream().map(ApiResponse.Error::getMessage).reduce((a, b) -> a + "\n" + b).orElse(""));
            }
            log.error(errorMessage.toString());
            throw new RuntimeException(errorMessage.toString());
        }
    }
}

