/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.searchapi;

import dev.langchain4j.internal.UriUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import dev.langchain4j.web.search.searchapi.OrganicResult;
import dev.langchain4j.web.search.searchapi.SearchApiClient;
import dev.langchain4j.web.search.searchapi.SearchApiWebSearchRequest;
import dev.langchain4j.web.search.searchapi.SearchApiWebSearchResponse;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SearchApiWebSearchEngine
implements WebSearchEngine {
    private static final String DEFAULT_BASE_URL = "https://www.searchapi.io";
    private static final String DEFAULT_ENGINE = "google";
    private final String apiKey;
    private final String engine;
    private final SearchApiClient client;
    private final Map<String, Object> optionalParameters;

    public SearchApiWebSearchEngine(String apiKey, String baseUrl, Duration timeout, String engine, Map<String, Object> optionalParameters) {
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.engine = (String)Utils.getOrDefault((Object)engine, (Object)DEFAULT_ENGINE);
        this.optionalParameters = Utils.getOrDefault((Map)Utils.copyIfNotNull(optionalParameters), new HashMap());
        this.client = SearchApiClient.builder().timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(30L))).baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)DEFAULT_BASE_URL)).build();
    }

    public static SearchApiWebSearchEngineBuilder builder() {
        return new SearchApiWebSearchEngineBuilder();
    }

    public WebSearchResults search(WebSearchRequest webSearchRequest) {
        SearchApiWebSearchRequest request = SearchApiWebSearchRequest.builder().apiKey(this.apiKey).engine(this.engine).query(webSearchRequest.searchTerms()).optionalParameters(this.optionalParameters).additionalRequestParameters(webSearchRequest.additionalParams()).build();
        SearchApiWebSearchResponse response = this.client.search(request);
        return this.toWebSearchResults(response);
    }

    private WebSearchResults toWebSearchResults(SearchApiWebSearchResponse response) {
        List<OrganicResult> organicResults = response.getOrganicResults();
        Long totalResults = SearchApiWebSearchEngine.getTotalResults(response.getSearchInformation());
        WebSearchInformationResult searchInformation = WebSearchInformationResult.from((Long)totalResults, (Integer)this.getCurrentPage(response.getPagination()), null);
        Map searchMetadata = Utils.getOrDefault(response.getSearchParameters(), new HashMap());
        this.addToMetadata(searchMetadata, response.getSearchMetadata());
        return WebSearchResults.from((Map)searchMetadata, (WebSearchInformationResult)searchInformation, this.toWebSearchOrganicResults(organicResults));
    }

    private static long getTotalResults(Map<String, Object> searchInformation) {
        if (searchInformation != null && searchInformation.containsKey("total_results")) {
            Object totalResults = searchInformation.get("total_results");
            return totalResults instanceof Integer ? ((Integer)totalResults).longValue() : ((Long)totalResults).longValue();
        }
        return 0L;
    }

    private Integer getCurrentPage(Map<String, Object> pagination) {
        if (pagination != null && pagination.containsKey("current")) {
            return (Integer)pagination.get("current");
        }
        return null;
    }

    private void addToMetadata(Map<String, Object> metadata, Map<String, Object> dataToAdd) {
        if (dataToAdd != null) {
            metadata.putAll(dataToAdd);
        }
    }

    private List<WebSearchOrganicResult> toWebSearchOrganicResults(List<OrganicResult> organicResults) {
        return organicResults.stream().map(result -> {
            HashMap<String, String> metadata = new HashMap<String, String>(2);
            metadata.put("position", result.getPosition());
            return WebSearchOrganicResult.from((String)result.getTitle(), (URI)UriUtils.createUriSafely((String)result.getLink()), (String)((String)Utils.getOrDefault((Object)result.getSnippet(), (Object)"")), null, metadata);
        }).collect(Collectors.toList());
    }

    public static WebSearchEngine withApiKey(String apiKey) {
        return SearchApiWebSearchEngine.builder().apiKey(apiKey).build();
    }

    public static class SearchApiWebSearchEngineBuilder {
        private String apiKey;
        private String baseUrl;
        private Duration timeout;
        private String engine;
        private Map<String, Object> optionalParameters;

        SearchApiWebSearchEngineBuilder() {
        }

        public SearchApiWebSearchEngineBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public SearchApiWebSearchEngineBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public SearchApiWebSearchEngineBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public SearchApiWebSearchEngineBuilder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public SearchApiWebSearchEngineBuilder optionalParameters(Map<String, Object> optionalParameters) {
            this.optionalParameters = optionalParameters;
            return this;
        }

        public SearchApiWebSearchEngine build() {
            return new SearchApiWebSearchEngine(this.apiKey, this.baseUrl, this.timeout, this.engine, this.optionalParameters);
        }

        public String toString() {
            return "SearchApiWebSearchEngine.SearchApiWebSearchEngineBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", timeout=" + String.valueOf(this.timeout) + ", engine=" + this.engine + ", optionalParameters=" + String.valueOf(this.optionalParameters) + ")";
        }
    }
}

