/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.google.customsearch;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleSearchApiHttpResponseLoggingInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleSearchApiHttpResponseLoggingInterceptor.class);

    GoogleSearchApiHttpResponseLoggingInterceptor() {
    }

    public void interceptResponse(HttpResponse httpResponse) {
        this.log(httpResponse);
    }

    private void log(HttpResponse httpResponse) {
        try {
            httpResponse.getRequest().setParser((ObjectParser)new GsonFactory().createJsonObjectParser());
            LOGGER.debug("Response:\n- status code: {}\n- headers: {}", (Object)httpResponse.getStatusCode(), (Object)GoogleSearchApiHttpResponseLoggingInterceptor.getHeaders(httpResponse.getHeaders()));
        }
        catch (Exception e) {
            LOGGER.warn("Error while logging response: {}", (Object)e.getMessage());
        }
    }

    private static String getHeaders(HttpHeaders headers) {
        return headers.entrySet().stream().map(entry -> String.format("[%s: %s]", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }
}

