/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.google.customsearch;

import com.google.api.client.json.GenericJson;
import com.google.api.services.customsearch.v1.model.Result;
import com.google.api.services.customsearch.v1.model.Search;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import dev.langchain4j.web.search.google.customsearch.GoogleCustomSearchApiClient;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GoogleCustomWebSearchEngine
implements WebSearchEngine {
    private final GoogleCustomSearchApiClient googleCustomSearchApiClient;
    private final Boolean includeImages;

    public GoogleCustomWebSearchEngine(String apiKey, String csi, Boolean siteRestrict, Boolean includeImages, Duration timeout, Integer maxRetries, Boolean logRequests, Boolean logResponses) {
        this.googleCustomSearchApiClient = GoogleCustomSearchApiClient.builder().apiKey(apiKey).csi(csi).siteRestrict((Boolean)Utils.getOrDefault((Object)siteRestrict, (Object)false)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).maxRetries((Integer)Utils.getOrDefault((Object)maxRetries, (Object)3)).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.includeImages = (Boolean)Utils.getOrDefault((Object)includeImages, (Object)false);
    }

    public static GoogleCustomWebSearchEngine withApiKeyAndCsi(String apiKey, String csi) {
        return GoogleCustomWebSearchEngine.builder().apiKey(apiKey).csi(csi).build();
    }

    public WebSearchResults search(WebSearchRequest webSearchRequest) {
        ValidationUtils.ensureNotNull((Object)webSearchRequest, (String)"webSearchRequest");
        Search.Queries.Request requestQuery = new Search.Queries.Request();
        requestQuery.setSearchTerms(webSearchRequest.searchTerms());
        requestQuery.setCount((Integer)Utils.getOrDefault((Object)webSearchRequest.maxResults(), (Object)5));
        requestQuery.setGl(webSearchRequest.geoLocation());
        requestQuery.setLanguage(webSearchRequest.language());
        requestQuery.setStartPage(webSearchRequest.startPage());
        requestQuery.setStartIndex(webSearchRequest.startIndex());
        requestQuery.setSafe(webSearchRequest.safeSearch() != false ? "active" : "off");
        requestQuery.setFilter("1");
        requestQuery.setCr(GoogleCustomWebSearchEngine.setCountryRestrict(webSearchRequest));
        webSearchRequest.additionalParams().forEach((arg_0, arg_1) -> ((Search.Queries.Request)requestQuery).set(arg_0, arg_1));
        boolean searchTypeImage = "image".equals(requestQuery.getSearchType());
        Search search = this.googleCustomSearchApiClient.searchResults(requestQuery);
        Map<String, Object> searchMetadata = GoogleCustomWebSearchEngine.toSearchMetadata(search, searchTypeImage);
        HashMap<String, Object> searchInformationMetadata = new HashMap<String, Object>();
        if (this.includeImages.booleanValue() && !searchTypeImage) {
            requestQuery.setSearchType("image");
            Search imagesSearch = this.googleCustomSearchApiClient.searchResults(requestQuery);
            List<ImageSearchResult> images = imagesSearch.getItems().stream().map(result -> ImageSearchResult.from(result.getTitle(), URI.create(result.getLink()), URI.create(result.getImage().getContextLink()), URI.create(result.getImage().getThumbnailLink()))).collect(Collectors.toList());
            GoogleCustomWebSearchEngine.addImagesToSearchInformation(searchInformationMetadata, images);
        }
        return WebSearchResults.from(searchMetadata, (WebSearchInformationResult)WebSearchInformationResult.from((Long)Long.valueOf((String)Utils.getOrDefault((Object)search.getSearchInformation().getTotalResults(), (Object)"0")), (Integer)(!Utils.isNullOrEmpty((Collection)search.getQueries().getRequest()) ? GoogleCustomWebSearchEngine.calculatePageNumberFromQueries((GenericJson)search.getQueries().getRequest().get(0)) : 1), searchInformationMetadata.isEmpty() ? null : searchInformationMetadata), search.getItems().stream().map(result -> WebSearchOrganicResult.from((String)result.getTitle(), (URI)URI.create(result.getLink()), (String)result.getSnippet(), null, GoogleCustomWebSearchEngine.toResultMetadataMap(result, searchTypeImage))).collect(Collectors.toList()));
    }

    private static void addImagesToSearchInformation(Map<String, Object> searchInformationMetadata, List<ImageSearchResult> images) {
        if (!Utils.isNullOrEmpty(images)) {
            searchInformationMetadata.put("images", images);
        }
    }

    private static Map<String, Object> toSearchMetadata(Search search, Boolean searchTypeImage) {
        if (search == null) {
            return null;
        }
        HashMap<String, Object> searchMetadata = new HashMap<String, Object>();
        searchMetadata.put("status", "Success");
        searchMetadata.put("searchTime", search.getSearchInformation().getSearchTime());
        searchMetadata.put("processedAt", LocalDateTime.now().toString());
        searchMetadata.put("searchType", searchTypeImage != false ? "images" : "web");
        searchMetadata.putAll(search.getContext());
        return searchMetadata;
    }

    private static Map<String, String> toResultMetadataMap(Result result, boolean searchTypeImage) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (searchTypeImage) {
            metadata.put("imageLink", result.getLink());
            metadata.put("contextLink", result.getImage().getContextLink());
            metadata.put("thumbnailLink", result.getImage().getThumbnailLink());
            metadata.put("mimeType", result.getMime());
            return metadata;
        }
        if (!result.getPagemap().isEmpty()) {
            result.getPagemap().forEach((key, value) -> {
                if (key.equals("metatags")) {
                    if (value instanceof List) {
                        metadata.put((String)key, ((List)value).stream().map(Object::toString).reduce((a, b) -> a + ", " + b).orElse(""));
                    } else {
                        metadata.put((String)key, value.toString());
                    }
                }
                metadata.put("mimeType", Utils.isNotNullOrBlank((String)result.getMime()) ? result.getMime() : "text/html");
            });
            return metadata;
        }
        return null;
    }

    private static Integer calculatePageNumberFromQueries(GenericJson query) {
        if (query instanceof Search.Queries.PreviousPage) {
            Search.Queries.PreviousPage previousPage = (Search.Queries.PreviousPage)query;
            return GoogleCustomWebSearchEngine.calculatePageNumber(previousPage.getStartIndex());
        }
        if (query instanceof Search.Queries.Request) {
            Search.Queries.Request currentPage = (Search.Queries.Request)query;
            return GoogleCustomWebSearchEngine.calculatePageNumber((Integer)Utils.getOrDefault((Object)currentPage.getStartIndex(), (Object)1));
        }
        if (query instanceof Search.Queries.NextPage) {
            Search.Queries.NextPage nextPage = (Search.Queries.NextPage)query;
            return GoogleCustomWebSearchEngine.calculatePageNumber(nextPage.getStartIndex());
        }
        return null;
    }

    private static Integer calculatePageNumber(Integer startIndex) {
        if (startIndex == null) {
            return null;
        }
        return (startIndex - 1) / 10 + 1;
    }

    private static String setCountryRestrict(WebSearchRequest webSearchRequest) {
        return webSearchRequest.additionalParams().get("cr") != null ? webSearchRequest.additionalParams().get("cr").toString() : (Utils.isNotNullOrBlank((String)webSearchRequest.geoLocation()) ? "country" + webSearchRequest.geoLocation().toUpperCase() : "");
    }

    public static GoogleCustomWebSearchEngineBuilder builder() {
        return new GoogleCustomWebSearchEngineBuilder();
    }

    public static class GoogleCustomWebSearchEngineBuilder {
        private String apiKey;
        private String csi;
        private Boolean siteRestrict;
        private Boolean includeImages;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;

        GoogleCustomWebSearchEngineBuilder() {
        }

        public GoogleCustomWebSearchEngineBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder siteRestrict(Boolean siteRestrict) {
            this.siteRestrict = siteRestrict;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder includeImages(Boolean includeImages) {
            this.includeImages = includeImages;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public GoogleCustomWebSearchEngineBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public GoogleCustomWebSearchEngine build() {
            return new GoogleCustomWebSearchEngine(this.apiKey, this.csi, this.siteRestrict, this.includeImages, this.timeout, this.maxRetries, this.logRequests, this.logResponses);
        }

        public String toString() {
            return "GoogleCustomWebSearchEngine.GoogleCustomWebSearchEngineBuilder(apiKey=" + this.apiKey + ", csi=" + this.csi + ", siteRestrict=" + this.siteRestrict + ", includeImages=" + this.includeImages + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ")";
        }
    }

    public static final class ImageSearchResult {
        private final String title;
        private final URI imageLink;
        private final URI contextLink;
        private final URI thumbnailLink;

        private ImageSearchResult(String title, URI imageLink) {
            this.title = (String)ValidationUtils.ensureNotNull((Object)title, (String)"title");
            this.imageLink = (URI)ValidationUtils.ensureNotNull((Object)imageLink, (String)"imageLink");
            this.contextLink = null;
            this.thumbnailLink = null;
        }

        private ImageSearchResult(String title, URI imageLink, URI contextLink, URI thumbnailLink) {
            this.title = (String)ValidationUtils.ensureNotNull((Object)title, (String)"title");
            this.imageLink = (URI)ValidationUtils.ensureNotNull((Object)imageLink, (String)"imageLink");
            this.contextLink = contextLink;
            this.thumbnailLink = thumbnailLink;
        }

        public String title() {
            return this.title;
        }

        public URI imageLink() {
            return this.imageLink;
        }

        public URI contextLink() {
            return this.contextLink;
        }

        public URI thumbnailLink() {
            return this.thumbnailLink;
        }

        public String toString() {
            return "ImageSearchResult{title='" + this.title + '\'' + ", imageLink=" + this.imageLink + ", contextLink=" + this.contextLink + ", thumbnailLink=" + this.thumbnailLink + '}';
        }

        public static ImageSearchResult from(String title, URI imageLink) {
            return new ImageSearchResult(title, imageLink);
        }

        public static ImageSearchResult from(String title, URI imageLink, URI contextLink, URI thumbnailLink) {
            return new ImageSearchResult(title, imageLink, contextLink, thumbnailLink);
        }
    }
}

