/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.watsonx;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.auth.iam.IAMAuthenticator;
import com.ibm.watsonx.ai.rerank.RerankParameters;
import com.ibm.watsonx.ai.rerank.RerankResponse;
import com.ibm.watsonx.ai.rerank.RerankService;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.scoring.ScoringModel;
import dev.langchain4j.model.watsonx.WatsonxBuilder;
import dev.langchain4j.model.watsonx.WatsonxExceptionMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WatsonxScoringModel
implements ScoringModel {
    private final RerankService rerankService;

    private WatsonxScoringModel(Builder builder) {
        RerankService.Builder rerankServiceBuilder = RerankService.builder();
        if (Objects.nonNull(builder.authenticationProvider)) {
            rerankServiceBuilder.authenticationProvider(builder.authenticationProvider);
        } else {
            rerankServiceBuilder.authenticationProvider((AuthenticationProvider)IAMAuthenticator.builder().apiKey(builder.apiKey).build());
        }
        this.rerankService = ((RerankService.Builder)((RerankService.Builder)((RerankService.Builder)((RerankService.Builder)((RerankService.Builder)((RerankService.Builder)((RerankService.Builder)((RerankService.Builder)rerankServiceBuilder.baseUrl(builder.baseUrl)).modelId(builder.modelName)).version(builder.version)).projectId(builder.projectId)).spaceId(builder.spaceId)).timeout(builder.timeout)).logRequests(builder.logRequests)).logResponses(builder.logResponses)).build();
    }

    public Response<List<Double>> scoreAll(List<TextSegment> segments, String query) {
        return this.scoreAll(segments, query, null);
    }

    public Response<List<Double>> scoreAll(List<TextSegment> segments, String query, RerankParameters parameters) {
        if (Objects.isNull(segments) || segments.isEmpty()) {
            return Response.from(List.of());
        }
        if (Objects.isNull(query) || query.isBlank()) {
            return Response.from(List.of());
        }
        List<String> inputs = segments.stream().map(TextSegment::text).toList();
        RerankResponse response = (RerankResponse)WatsonxExceptionMapper.INSTANCE.withExceptionMapper(() -> this.rerankService.rerank(query, inputs, parameters));
        Double[] content = new Double[response.results().size()];
        for (RerankResponse.RerankResult rerankResult : response.results()) {
            content[rerankResult.index()] = rerankResult.score();
        }
        return Response.from(Arrays.asList(content), (TokenUsage)new TokenUsage(Integer.valueOf(response.inputTokenCount())));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxBuilder<Builder> {
        private String modelName;

        private Builder() {
        }

        @Override
        public Builder baseUrl(CloudRegion cloudRegion) {
            return (Builder)super.baseUrl(cloudRegion.getMlEndpoint());
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Override
        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public WatsonxScoringModel build() {
            return new WatsonxScoringModel(this);
        }
    }
}

