/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.watsonx;

import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.auth.iam.IAMAuthenticator;
import com.ibm.watsonx.ai.detection.DetectionService;
import com.ibm.watsonx.ai.detection.DetectionTextRequest;
import com.ibm.watsonx.ai.detection.DetectionTextResponse;
import com.ibm.watsonx.ai.detection.detector.BaseDetector;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.LangChain4jException;
import dev.langchain4j.internal.DefaultExecutorProvider;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.watsonx.WatsonxBuilder;
import dev.langchain4j.model.watsonx.WatsonxExceptionMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class WatsonxModerationModel
implements ModerationModel {
    private final List<BaseDetector> detectors;
    private final DetectionService detectionService;

    public WatsonxModerationModel(Builder builder) {
        if (Objects.isNull(builder.detectors) || builder.detectors.isEmpty()) {
            throw new IllegalArgumentException("At least one detector must be provided");
        }
        this.detectors = builder.detectors;
        DetectionService.Builder detectionServiceBuilder = DetectionService.builder();
        if (Objects.nonNull(builder.authenticationProvider)) {
            detectionServiceBuilder.authenticationProvider(builder.authenticationProvider);
        } else {
            detectionServiceBuilder.authenticationProvider((AuthenticationProvider)IAMAuthenticator.builder().apiKey(builder.apiKey).build());
        }
        this.detectionService = ((DetectionService.Builder)((DetectionService.Builder)((DetectionService.Builder)((DetectionService.Builder)((DetectionService.Builder)((DetectionService.Builder)((DetectionService.Builder)detectionServiceBuilder.baseUrl(builder.baseUrl)).version(builder.version)).projectId(builder.projectId)).spaceId(builder.spaceId)).timeout(builder.timeout)).logRequests(builder.logRequests)).logResponses(builder.logResponses)).build();
    }

    public Response<Moderation> moderate(String text) {
        DetectionTextRequest request = DetectionTextRequest.builder().input(text).detectors(this.detectors).build();
        return (Response)WatsonxExceptionMapper.INSTANCE.withExceptionMapper(() -> this.detectionService.detect(request).detections().stream().findFirst().map(this::createModerationResponse).orElse(Response.from((Object)Moderation.notFlagged())));
    }

    public Response<Moderation> moderate(List<ChatMessage> messages) {
        List<CompletableFuture> futures = messages.stream().map(this::toText).map(message -> CompletableFuture.supplyAsync(() -> this.moderate((String)message), DefaultExecutorProvider.getDefaultExecutorService())).toList();
        try {
            return futures.stream().map(CompletableFuture::join).filter(response -> ((Moderation)response.content()).flagged()).findFirst().orElse(Response.from((Object)Moderation.notFlagged()));
        }
        catch (CompletionException e) {
            RuntimeException runtimeException;
            Throwable cause = e.getCause();
            if (cause instanceof LangChain4jException) {
                LangChain4jException langchainException = (LangChain4jException)cause;
                runtimeException = langchainException;
            } else {
                runtimeException = new RuntimeException(cause);
            }
            throw runtimeException;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private Response<Moderation> createModerationResponse(DetectionTextResponse detectionTextResponse) {
        Moderation moderation = Moderation.flagged((String)detectionTextResponse.getText());
        Map<String, Float> metadata = Map.of("detection", detectionTextResponse.getDetection(), "detection_type", detectionTextResponse.getDetectionType(), "start", detectionTextResponse.getStart(), "end", detectionTextResponse.getEnd(), "score", Float.valueOf(detectionTextResponse.getScore()));
        return Response.from((Object)moderation, null, null, metadata);
    }

    private String toText(ChatMessage chatMessage) {
        if (chatMessage instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)chatMessage;
            return systemMessage.text();
        }
        if (chatMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)chatMessage;
            return userMessage.singleText();
        }
        if (chatMessage instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)chatMessage;
            return aiMessage.text();
        }
        if (chatMessage instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)chatMessage;
            return toolExecutionResultMessage.text();
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(chatMessage.type()));
    }

    public static class Builder
    extends WatsonxBuilder<Builder> {
        private List<BaseDetector> detectors;

        private Builder() {
        }

        public Builder detectors(List<BaseDetector> detectors) {
            this.detectors = detectors;
            return this;
        }

        public Builder detectors(BaseDetector ... detectors) {
            return this.detectors(List.of(detectors));
        }

        public WatsonxModerationModel build() {
            return new WatsonxModerationModel(this);
        }
    }
}

