/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.watsonx;

import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.ThinkingEffort;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WatsonxChatRequestParameters
extends DefaultChatRequestParameters {
    public static final WatsonxChatRequestParameters EMPTY = WatsonxChatRequestParameters.builder().build();
    private final String projectId;
    private final String spaceId;
    private final Thinking thinking;
    private final Map<String, Integer> logitBias;
    private final Boolean logprobs;
    private final Integer topLogprobs;
    private final Integer seed;
    private final String toolChoiceName;
    private final Set<String> guidedChoice;
    private final String guidedRegex;
    private final String guidedGrammar;
    private final Double repetitionPenalty;
    private final Double lengthPenalty;
    private final Duration timeout;

    private WatsonxChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.projectId = builder.projectId;
        this.spaceId = builder.spaceId;
        this.logitBias = builder.logitBias;
        this.logprobs = builder.logprobs;
        this.topLogprobs = builder.topLogprobs;
        this.seed = builder.seed;
        this.toolChoiceName = builder.toolChoiceName;
        this.timeout = builder.timeout;
        this.thinking = builder.thinking;
        this.guidedChoice = builder.guidedChoice;
        this.guidedRegex = builder.guidedRegex;
        this.guidedGrammar = builder.guidedGrammar;
        this.repetitionPenalty = builder.repetitionPenalty;
        this.lengthPenalty = builder.lengthPenalty;
    }

    public String projectId() {
        return this.projectId;
    }

    public String spaceId() {
        return this.spaceId;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public Boolean logprobs() {
        return this.logprobs;
    }

    public Integer topLogprobs() {
        return this.topLogprobs;
    }

    public Integer seed() {
        return this.seed;
    }

    public String toolChoiceName() {
        return this.toolChoiceName;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Thinking thinking() {
        return this.thinking;
    }

    public Set<String> guidedChoice() {
        return this.guidedChoice;
    }

    public String guidedRegex() {
        return this.guidedRegex;
    }

    public String guidedGrammar() {
        return this.guidedGrammar;
    }

    public Double repetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Double lengthPenalty() {
        return this.lengthPenalty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ChatRequestParameters overrideWith(ChatRequestParameters that) {
        return WatsonxChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private String projectId;
        private String spaceId;
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer seed;
        private String toolChoiceName;
        private Duration timeout;
        private Set<String> guidedChoice;
        private String guidedRegex;
        private String guidedGrammar;
        private Double repetitionPenalty;
        private Double lengthPenalty;
        private Thinking thinking;

        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof WatsonxChatRequestParameters) {
                WatsonxChatRequestParameters watsonxParameters = (WatsonxChatRequestParameters)parameters;
                this.projectId((String)Utils.getOrDefault((Object)watsonxParameters.projectId(), (Object)this.projectId));
                this.spaceId((String)Utils.getOrDefault((Object)watsonxParameters.spaceId(), (Object)this.spaceId));
                this.logitBias(Utils.getOrDefault(watsonxParameters.logitBias(), this.logitBias));
                this.logprobs((Boolean)Utils.getOrDefault((Object)watsonxParameters.logprobs(), (Object)this.logprobs));
                this.topLogprobs((Integer)Utils.getOrDefault((Object)watsonxParameters.topLogprobs(), (Object)this.topLogprobs));
                this.seed((Integer)Utils.getOrDefault((Object)watsonxParameters.seed(), (Object)this.seed));
                this.toolChoiceName((String)Utils.getOrDefault((Object)watsonxParameters.toolChoiceName(), (Object)this.toolChoiceName));
                this.timeout((Duration)Utils.getOrDefault((Object)watsonxParameters.timeout(), (Object)this.timeout));
                this.thinking((Thinking)Utils.getOrDefault((Object)watsonxParameters.thinking(), (Object)this.thinking));
                this.guidedChoice((Set)Utils.getOrDefault(watsonxParameters.guidedChoice(), this.guidedChoice));
                this.guidedRegex((String)Utils.getOrDefault((Object)watsonxParameters.guidedRegex(), (Object)this.guidedRegex));
                this.guidedGrammar((String)Utils.getOrDefault((Object)watsonxParameters.guidedGrammar(), (Object)this.guidedGrammar));
                this.repetitionPenalty((Double)Utils.getOrDefault((Object)watsonxParameters.repetitionPenalty(), (Object)this.repetitionPenalty));
                this.lengthPenalty((Double)Utils.getOrDefault((Object)watsonxParameters.lengthPenalty(), (Object)this.lengthPenalty));
            }
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder toolChoiceName(String toolChoiceName) {
            this.toolChoiceName = toolChoiceName;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder thinking(boolean enabled) {
            return this.thinking(Thinking.builder().enabled(Boolean.valueOf(enabled)).build());
        }

        public Builder thinking(ExtractionTags tags) {
            if (Objects.nonNull(tags)) {
                return this.thinking(Thinking.of((ExtractionTags)tags));
            }
            this.thinking = null;
            return this;
        }

        public Builder thinking(ThinkingEffort thinkingEffort) {
            if (Objects.nonNull(thinkingEffort)) {
                return this.thinking(Thinking.of((ThinkingEffort)thinkingEffort));
            }
            this.thinking = null;
            return this;
        }

        public Builder thinking(Thinking thinking) {
            this.thinking = thinking;
            return this;
        }

        public Builder guidedChoice(String ... guidedChoice) {
            return this.guidedChoice(Set.of(guidedChoice));
        }

        public Builder guidedChoice(Set<String> guidedChoices) {
            this.guidedChoice = guidedChoices;
            return this;
        }

        public Builder guidedRegex(String guidedRegex) {
            this.guidedRegex = guidedRegex;
            return this;
        }

        public Builder guidedGrammar(String guidedGrammar) {
            this.guidedGrammar = guidedGrammar;
            return this;
        }

        public Builder repetitionPenalty(Double repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder lengthPenalty(Double lengthPenalty) {
            this.lengthPenalty = lengthPenalty;
            return this;
        }

        public WatsonxChatRequestParameters build() {
            return new WatsonxChatRequestParameters(this);
        }
    }
}

