/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.vertexai.anthropic.internal.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.vertexai.anthropic.internal.api.AnthropicCacheControl;
import dev.langchain4j.model.vertexai.anthropic.internal.api.AnthropicSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AnthropicContent {
    public String type;
    public String text;
    public AnthropicSource source;
    public String id;
    public String name;
    public Object input;
    @JsonProperty(value="tool_use_id")
    public String toolUseId;
    public String content;
    public AnthropicCacheControl cacheControl;

    public AnthropicContent() {
    }

    public AnthropicContent(String type, String text) {
        this.type = type;
        this.text = text;
    }

    public static AnthropicContent textContent(String text) {
        return new AnthropicContent("text", text);
    }

    public static AnthropicContent textContentWithCache(String text, AnthropicCacheControl cacheControl) {
        AnthropicContent content = new AnthropicContent("text", text);
        content.cacheControl = cacheControl;
        return content;
    }

    public static AnthropicContent imageContent(AnthropicSource source) {
        AnthropicContent content = new AnthropicContent();
        content.type = "image";
        content.source = source;
        return content;
    }

    public static AnthropicContent toolUse(String id, String name, Object input) {
        AnthropicContent content = new AnthropicContent();
        content.type = "tool_use";
        content.id = id;
        content.name = name;
        content.input = input;
        return content;
    }

    public static AnthropicContent toolResult(String toolUseId, String text) {
        AnthropicContent content = new AnthropicContent();
        content.type = "tool_result";
        content.toolUseId = toolUseId;
        content.content = text;
        return content;
    }
}

