/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j;

import dev.langchain4j.LangChain4jProperties;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.huggingface.HuggingFaceChatModel;
import dev.langchain4j.model.huggingface.HuggingFaceEmbeddingModel;
import dev.langchain4j.model.huggingface.HuggingFaceLanguageModel;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.moderation.ModerationModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiLanguageModel;
import dev.langchain4j.model.openai.OpenAiModerationModel;
import dev.langchain4j.service.IllegalConfigurationException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfiguration
@EnableConfigurationProperties(value={LangChain4jProperties.class})
public class LangChain4jAutoConfiguration {
    @Bean
    @Lazy
    @ConditionalOnMissingBean
    ChatLanguageModel chatLanguageModel(LangChain4jProperties properties) {
        switch (properties.getChatModel().getProvider()) {
            case OPEN_AI: {
                LangChain4jProperties.OpenAi openAi = properties.getChatModel().getOpenAi();
                return OpenAiChatModel.builder().apiKey(openAi.getApiKey()).modelName(openAi.getModelName()).temperature(openAi.getTemperature()).timeout(openAi.getTimeout()).logRequests(openAi.getLogRequests()).logResponses(openAi.getLogResponses()).build();
            }
            case HUGGING_FACE: {
                LangChain4jProperties.HuggingFace huggingFace = properties.getChatModel().getHuggingFace();
                return HuggingFaceChatModel.builder().accessToken(huggingFace.getAccessToken()).modelId(huggingFace.getModelId()).timeout(huggingFace.getTimeout()).temperature(huggingFace.getTemperature()).maxNewTokens(huggingFace.getMaxNewTokens()).returnFullText(huggingFace.getReturnFullText()).waitForModel(huggingFace.getWaitForModel()).build();
            }
        }
        throw new IllegalConfigurationException("Unsupported chat model provider: " + (Object)((Object)properties.getChatModel().getProvider()));
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    LanguageModel languageModel(LangChain4jProperties properties) {
        switch (properties.getLanguageModel().getProvider()) {
            case OPEN_AI: {
                LangChain4jProperties.OpenAi openAi = properties.getLanguageModel().getOpenAi();
                return OpenAiLanguageModel.builder().apiKey(openAi.getApiKey()).modelName(openAi.getModelName()).temperature(openAi.getTemperature()).timeout(openAi.getTimeout()).logRequests(openAi.getLogRequests()).logResponses(openAi.getLogResponses()).build();
            }
            case HUGGING_FACE: {
                LangChain4jProperties.HuggingFace huggingFace = properties.getLanguageModel().getHuggingFace();
                return HuggingFaceLanguageModel.builder().accessToken(huggingFace.getAccessToken()).modelId(huggingFace.getModelId()).timeout(huggingFace.getTimeout()).temperature(huggingFace.getTemperature()).maxNewTokens(huggingFace.getMaxNewTokens()).returnFullText(huggingFace.getReturnFullText()).waitForModel(huggingFace.getWaitForModel()).build();
            }
        }
        throw new IllegalConfigurationException("Unsupported language model provider: " + (Object)((Object)properties.getLanguageModel().getProvider()));
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    EmbeddingModel embeddingModel(LangChain4jProperties properties) {
        switch (properties.getEmbeddingModel().getProvider()) {
            case OPEN_AI: {
                LangChain4jProperties.OpenAi openAi = properties.getEmbeddingModel().getOpenAi();
                return OpenAiEmbeddingModel.builder().apiKey(openAi.getApiKey()).modelName(openAi.getModelName()).timeout(openAi.getTimeout()).logRequests(openAi.getLogRequests()).logResponses(openAi.getLogResponses()).build();
            }
            case HUGGING_FACE: {
                LangChain4jProperties.HuggingFace huggingFace = properties.getEmbeddingModel().getHuggingFace();
                return HuggingFaceEmbeddingModel.builder().accessToken(huggingFace.getAccessToken()).modelId(huggingFace.getModelId()).waitForModel(huggingFace.getWaitForModel()).timeout(huggingFace.getTimeout()).build();
            }
        }
        throw new IllegalConfigurationException("Unsupported embedding model provider: " + (Object)((Object)properties.getEmbeddingModel().getProvider()));
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    ModerationModel moderationModel(LangChain4jProperties properties) {
        if (properties.getModerationModel().getProvider() != LangChain4jProperties.ModelProvider.OPEN_AI) {
            throw new IllegalConfigurationException("Unsupported moderation model provider: " + (Object)((Object)properties.getModerationModel().getProvider()));
        }
        LangChain4jProperties.OpenAi openAi = properties.getModerationModel().getOpenAi();
        return OpenAiModerationModel.builder().apiKey(openAi.getApiKey()).modelName(openAi.getModelName()).timeout(openAi.getTimeout()).logRequests(openAi.getLogRequests()).logResponses(openAi.getLogResponses()).build();
    }
}

