/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.pinecone;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import io.pinecone.PineconeClient;
import io.pinecone.PineconeClientConfig;
import io.pinecone.PineconeConnection;
import io.pinecone.PineconeConnectionConfig;
import io.pinecone.proto.FetchRequest;
import io.pinecone.proto.QueryRequest;
import io.pinecone.proto.QueryVector;
import io.pinecone.proto.ScoredVector;
import io.pinecone.proto.SingleQueryResults;
import io.pinecone.proto.UpsertRequest;
import io.pinecone.proto.Vector;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class PineconeEmbeddingStore
implements EmbeddingStore<TextSegment> {
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String DEFAULT_METADATA_TEXT_KEY = "text_segment";
    private final PineconeConnection connection;
    private final String nameSpace;
    private final String metadataTextKey;

    public PineconeEmbeddingStore(String apiKey, String environment, String projectId, String index, String nameSpace, String metadataTextKey) {
        PineconeClientConfig configuration = new PineconeClientConfig().withApiKey(apiKey).withEnvironment(environment).withProjectName(projectId);
        PineconeClient pineconeClient = new PineconeClient(configuration);
        PineconeConnectionConfig connectionConfig = new PineconeConnectionConfig().withIndexName(index);
        this.connection = pineconeClient.connect(connectionConfig);
        this.nameSpace = nameSpace == null ? DEFAULT_NAMESPACE : nameSpace;
        this.metadataTextKey = metadataTextKey == null ? DEFAULT_METADATA_TEXT_KEY : metadataTextKey;
    }

    public String add(Embedding embedding) {
        String id = Utils.randomUUID();
        this.add(id, embedding);
        return id;
    }

    public void add(String id, Embedding embedding) {
        this.addInternal(id, embedding, null);
    }

    public String add(Embedding embedding, TextSegment textSegment) {
        String id = Utils.randomUUID();
        this.addInternal(id, embedding, textSegment);
        return id;
    }

    public List<String> addAll(List<Embedding> embeddings) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, null);
        return ids;
    }

    public List<String> addAll(List<Embedding> embeddings, List<TextSegment> textSegments) {
        List<String> ids = embeddings.stream().map(ignored -> Utils.randomUUID()).collect(Collectors.toList());
        this.addAllInternal(ids, embeddings, textSegments);
        return ids;
    }

    private void addInternal(String id, Embedding embedding, TextSegment textSegment) {
        this.addAllInternal(Collections.singletonList(id), Collections.singletonList(embedding), textSegment == null ? null : Collections.singletonList(textSegment));
    }

    private void addAllInternal(List<String> ids, List<Embedding> embeddings, List<TextSegment> textSegments) {
        UpsertRequest.Builder upsertRequestBuilder = UpsertRequest.newBuilder().setNamespace(this.nameSpace);
        for (int i = 0; i < embeddings.size(); ++i) {
            String id = ids.get(i);
            Embedding embedding = embeddings.get(i);
            Vector.Builder vectorBuilder = Vector.newBuilder().setId(id).addAllValues((Iterable)embedding.vectorAsList());
            if (textSegments != null) {
                vectorBuilder.setMetadata(Struct.newBuilder().putFields(this.metadataTextKey, Value.newBuilder().setStringValue(textSegments.get(i).text()).build()));
            }
            upsertRequestBuilder.addVectors(vectorBuilder.build());
        }
        this.connection.getBlockingStub().upsert(upsertRequestBuilder.build());
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding referenceEmbedding, int maxResults, double minScore) {
        QueryVector queryVector = QueryVector.newBuilder().addAllValues((Iterable)referenceEmbedding.vectorAsList()).setTopK(maxResults).setNamespace(this.nameSpace).build();
        QueryRequest queryRequest = QueryRequest.newBuilder().addQueries(queryVector).setTopK(maxResults).build();
        List matchedVectorIds = ((SingleQueryResults)this.connection.getBlockingStub().query(queryRequest).getResultsList().get(0)).getMatchesList().stream().map(ScoredVector::getId).collect(Collectors.toList());
        if (matchedVectorIds.isEmpty()) {
            return Collections.emptyList();
        }
        Collection matchedVectors = this.connection.getBlockingStub().fetch(FetchRequest.newBuilder().addAllIds(matchedVectorIds).setNamespace(this.nameSpace).build()).getVectorsMap().values();
        List<EmbeddingMatch<TextSegment>> matches = matchedVectors.stream().map(vector -> this.toEmbeddingMatch((Vector)vector, referenceEmbedding)).filter(match -> match.score() >= minScore).sorted(Comparator.comparingDouble(EmbeddingMatch::score)).collect(Collectors.toList());
        Collections.reverse(matches);
        return matches;
    }

    private EmbeddingMatch<TextSegment> toEmbeddingMatch(Vector vector, Embedding referenceEmbedding) {
        Value textSegmentValue = (Value)vector.getMetadata().getFieldsMap().get(this.metadataTextKey);
        Embedding embedding = Embedding.from((List)vector.getValuesList());
        double cosineSimilarity = CosineSimilarity.between((Embedding)embedding, (Embedding)referenceEmbedding);
        return new EmbeddingMatch(Double.valueOf(RelevanceScore.fromCosineSimilarity((double)cosineSimilarity)), vector.getId(), embedding, textSegmentValue == null ? null : TextSegment.from((String)textSegmentValue.getStringValue()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiKey;
        private String environment;
        private String projectId;
        private String index;
        private String nameSpace;
        private String metadataTextKey;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder nameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
            return this;
        }

        public Builder metadataTextKey(String metadataTextKey) {
            this.metadataTextKey = metadataTextKey;
            return this;
        }

        public PineconeEmbeddingStore build() {
            return new PineconeEmbeddingStore(this.apiKey, this.environment, this.projectId, this.index, this.nameSpace, this.metadataTextKey);
        }
    }
}

