/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openaiofficial;

import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.client.OpenAIClient;
import com.openai.client.OpenAIClientAsync;
import com.openai.credential.Credential;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.openaiofficial.InternalOpenAiOfficialHelper;
import dev.langchain4j.model.openaiofficial.OpenAiOfficialChatRequestParameters;
import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class OpenAiOfficialBaseChatModel {
    protected OpenAIClient client;
    protected OpenAIClientAsync asyncClient;
    protected InternalOpenAiOfficialHelper.ModelHost modelHost;
    protected String modelName;
    protected OpenAiOfficialChatRequestParameters defaultRequestParameters;
    protected String responseFormat;
    protected Boolean strictJsonSchema;
    protected Boolean strictTools;
    protected TokenCountEstimator tokenCountEstimator;
    protected List<ChatModelListener> listeners;
    protected Set<Capability> supportedCapabilities;

    OpenAiOfficialBaseChatModel() {
    }

    public void init(String baseUrl, String apiKey, Credential credential, String azureDeploymentName, AzureOpenAIServiceVersion azureOpenAIServiceVersion, String organizationId, boolean isAzure, boolean isGitHubModels, OpenAIClient openAIClient, OpenAIClientAsync openAIClientAsync, ChatRequestParameters defaultRequestParameters, String modelName, Double temperature, Double topP, List<String> stop, Integer maxCompletionTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String responseFormat, Boolean strictJsonSchema, Integer seed, String user, Boolean strictTools, Boolean parallelToolCalls, Boolean store, Map<String, String> metadata, String serviceTier, Duration timeout, Integer maxRetries, Proxy proxy, TokenCountEstimator tokenCountEstimator, Map<String, String> customHeaders, List<ChatModelListener> listeners, Set<Capability> capabilities, boolean isAsync) {
        OpenAiOfficialChatRequestParameters openAiChatRequestParameters;
        ChatRequestParameters commonParameters;
        this.modelHost = InternalOpenAiOfficialHelper.detectModelHost(isAzure, isGitHubModels, baseUrl, azureDeploymentName, azureOpenAIServiceVersion);
        this.modelName = modelName;
        if (isAsync) {
            this.asyncClient = InternalOpenAiOfficialHelper.setupASyncClient(baseUrl, apiKey, credential, azureDeploymentName, azureOpenAIServiceVersion, this.modelHost, openAIClientAsync, organizationId, modelName, timeout, maxRetries, proxy, customHeaders);
        } else {
            this.client = InternalOpenAiOfficialHelper.setupSyncClient(baseUrl, apiKey, credential, azureDeploymentName, azureOpenAIServiceVersion, organizationId, this.modelHost, openAIClient, modelName, timeout, maxRetries, proxy, customHeaders);
        }
        if (defaultRequestParameters != null) {
            InternalOpenAiOfficialHelper.validate(defaultRequestParameters);
            commonParameters = defaultRequestParameters;
        } else {
            commonParameters = DefaultChatRequestParameters.EMPTY;
        }
        OpenAiOfficialChatRequestParameters openAiParameters = defaultRequestParameters instanceof OpenAiOfficialChatRequestParameters ? (openAiChatRequestParameters = (OpenAiOfficialChatRequestParameters)defaultRequestParameters) : OpenAiOfficialChatRequestParameters.EMPTY;
        this.defaultRequestParameters = ((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)((OpenAiOfficialChatRequestParameters.Builder)OpenAiOfficialChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)modelName, (Object)commonParameters.modelName()))).temperature((Double)Utils.getOrDefault((Object)temperature, (Object)commonParameters.temperature()))).topP((Double)Utils.getOrDefault((Object)topP, (Object)commonParameters.topP()))).frequencyPenalty((Double)Utils.getOrDefault((Object)frequencyPenalty, (Object)commonParameters.frequencyPenalty()))).presencePenalty((Double)Utils.getOrDefault((Object)presencePenalty, (Object)commonParameters.presencePenalty()))).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxCompletionTokens, (Object)commonParameters.maxOutputTokens()))).stopSequences(Utils.getOrDefault(stop, (List)commonParameters.stopSequences()))).toolSpecifications(commonParameters.toolSpecifications())).toolChoice(commonParameters.toolChoice())).responseFormat((ResponseFormat)Utils.getOrDefault((Object)InternalOpenAiOfficialHelper.fromOpenAiResponseFormat(responseFormat), (Object)commonParameters.responseFormat()))).maxCompletionTokens((Integer)Utils.getOrDefault((Object)maxCompletionTokens, (Object)openAiParameters.maxCompletionTokens())).logitBias(Utils.getOrDefault(logitBias, openAiParameters.logitBias())).parallelToolCalls((Boolean)Utils.getOrDefault((Object)parallelToolCalls, (Object)openAiParameters.parallelToolCalls())).seed((Integer)Utils.getOrDefault((Object)seed, (Object)openAiParameters.seed())).user((String)Utils.getOrDefault((Object)user, (Object)openAiParameters.user())).store((Boolean)Utils.getOrDefault((Object)store, (Object)openAiParameters.store())).metadata(Utils.getOrDefault(metadata, openAiParameters.metadata())).serviceTier((String)Utils.getOrDefault((Object)serviceTier, (Object)openAiParameters.serviceTier())).reasoningEffort(openAiParameters.reasoningEffort()).build();
        if ((this.modelHost.equals((Object)InternalOpenAiOfficialHelper.ModelHost.AZURE_OPENAI) || this.modelHost.equals((Object)InternalOpenAiOfficialHelper.ModelHost.GITHUB_MODELS)) && !this.defaultRequestParameters.modelName().equals(this.modelName)) {
            throw new UnsupportedFeatureException("Modifying the modelName is not supported");
        }
        this.responseFormat = responseFormat;
        this.strictJsonSchema = (Boolean)Utils.getOrDefault((Object)strictJsonSchema, (Object)false);
        this.strictTools = (Boolean)Utils.getOrDefault((Object)strictTools, (Object)false);
        this.tokenCountEstimator = tokenCountEstimator;
        this.listeners = Utils.copy(listeners);
        this.supportedCapabilities = Utils.copy(capabilities);
    }

    public OpenAiOfficialChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public Set<Capability> supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return switch (this.modelHost) {
            default -> throw new IncompatibleClassChangeError();
            case InternalOpenAiOfficialHelper.ModelHost.OPENAI -> ModelProvider.OPEN_AI;
            case InternalOpenAiOfficialHelper.ModelHost.AZURE_OPENAI -> ModelProvider.AZURE_OPEN_AI;
            case InternalOpenAiOfficialHelper.ModelHost.GITHUB_MODELS -> ModelProvider.GITHUB_MODELS;
        };
    }
}

