/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.model.ollama.Role;
import dev.langchain4j.model.ollama.ToolCall;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
class Message {
    private Role role;
    private String content;
    private List<String> images;
    private List<ToolCall> toolCalls;
    private Map<String, Object> additionalFields;

    Message() {
    }

    public Message(Role role, String content, List<String> images, List<ToolCall> toolCalls, Map<String, Object> additionalFields) {
        this.role = role;
        this.content = content;
        this.images = images;
        this.toolCalls = toolCalls;
        this.additionalFields = additionalFields;
    }

    static Builder builder() {
        return new Builder();
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalFields(Map<String, Object> additionalFields) {
        this.additionalFields = additionalFields;
    }

    static class Builder {
        private Role role;
        private String content;
        private List<String> images;
        private List<ToolCall> toolCalls;
        private Map<String, Object> additionalFields;

        Builder() {
        }

        Builder role(Role role) {
            this.role = role;
            return this;
        }

        Builder content(String content) {
            this.content = content;
            return this;
        }

        Builder images(List<String> images) {
            this.images = images;
            return this;
        }

        Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        Builder additionalFields(Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        Message build() {
            return new Message(this.role, this.content, this.images, this.toolCalls, this.additionalFields);
        }
    }
}

