/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.ChatResponse;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.DeleteModelRequest;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.ModelsListResponse;
import dev.langchain4j.model.ollama.OllamaChatModelListenerUtils;
import dev.langchain4j.model.ollama.OllamaJsonUtils;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.OllamaServerSentEventParser;
import dev.langchain4j.model.ollama.OllamaStreamingResponseBuilder;
import dev.langchain4j.model.ollama.RunningModelsListResponse;
import dev.langchain4j.model.ollama.ShowModelInformationRequest;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class OllamaClient {
    private final HttpClient httpClient;
    private final String baseUrl;
    private final Map<String, String> defaultHeaders;

    OllamaClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.connectTimeout())), (Object)Duration.ofSeconds(15L))).readTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.readTimeout())), (Object)Duration.ofSeconds(60L))).build();
        this.httpClient = builder.logRequests != null || builder.logResponses != null ? new LoggingHttpClient(httpClient, builder.logRequests, builder.logResponses) : httpClient;
        this.baseUrl = ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl");
        this.defaultHeaders = Utils.copyIfNotNull(builder.customHeaders);
    }

    static Builder builder() {
        return new Builder();
    }

    public CompletionResponse completion(CompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/generate").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), CompletionResponse.class);
    }

    public ChatResponse chat(ChatRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/chat").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), ChatResponse.class);
    }

    public void streamingCompletion(CompletionRequest request, final StreamingResponseHandler<String> handler) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/generate").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        this.httpClient.execute(httpRequest, (ServerSentEventParser)new OllamaServerSentEventParser(), new ServerSentEventListener(){
            final StringBuilder contentBuilder = new StringBuilder();

            public void onEvent(ServerSentEvent event) {
                CompletionResponse completionResponse = OllamaJsonUtils.fromJson(event.data(), CompletionResponse.class);
                this.contentBuilder.append(completionResponse.getResponse());
                handler.onNext(completionResponse.getResponse());
                if (Boolean.TRUE.equals(completionResponse.getDone())) {
                    Response response = Response.from((Object)this.contentBuilder.toString(), (TokenUsage)new TokenUsage(completionResponse.getPromptEvalCount(), completionResponse.getEvalCount()));
                    handler.onComplete(response);
                }
            }

            public void onError(Throwable throwable) {
                handler.onError(throwable);
            }
        });
    }

    public void streamingChat(ChatRequest request, final StreamingResponseHandler<AiMessage> handler, final List<ChatModelListener> listeners, List<ChatMessage> messages) {
        final ChatModelRequest modelListenerRequest = OllamaChatModelListenerUtils.createModelListenerRequest(request, messages, new ArrayList<ToolSpecification>());
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        OllamaChatModelListenerUtils.onListenRequest(listeners, modelListenerRequest, attributes);
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/chat").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        this.httpClient.execute(httpRequest, (ServerSentEventParser)new OllamaServerSentEventParser(), new ServerSentEventListener(){
            final OllamaStreamingResponseBuilder responseBuilder = new OllamaStreamingResponseBuilder();

            public void onEvent(ServerSentEvent event) {
                ChatResponse chatResponse = OllamaJsonUtils.fromJson(event.data(), ChatResponse.class);
                String content = chatResponse.getMessage().getContent();
                this.responseBuilder.append(chatResponse);
                handler.onNext(content);
                if (Boolean.TRUE.equals(chatResponse.getDone())) {
                    Response<AiMessage> response = this.responseBuilder.build();
                    OllamaChatModelListenerUtils.onListenResponse(listeners, response, modelListenerRequest, attributes);
                    handler.onComplete(response);
                }
            }

            public void onError(Throwable throwable) {
                OllamaChatModelListenerUtils.onListenError(listeners, throwable, modelListenerRequest, this.responseBuilder.build(), attributes);
                handler.onError(throwable);
            }
        });
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/embed").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), EmbeddingResponse.class);
    }

    public ModelsListResponse listModels() {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.GET).url(this.baseUrl, "api/tags").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), ModelsListResponse.class);
    }

    public OllamaModelCard showInformation(ShowModelInformationRequest showInformationRequest) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/show").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(showInformationRequest)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), OllamaModelCard.class);
    }

    public RunningModelsListResponse listRunningModels() {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.GET).url(this.baseUrl, "api/ps").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), RunningModelsListResponse.class);
    }

    public Void deleteModel(DeleteModelRequest deleteModelRequest) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.DELETE).url(this.baseUrl, "api/delete").addHeader("Content-Type", new String[]{"application/json"}).addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(deleteModelRequest)).build();
        this.httpClient.execute(httpRequest);
        return null;
    }

    static class Builder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        Builder() {
        }

        Builder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Builder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        Builder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        OllamaClient build() {
            return new OllamaClient(this);
        }
    }
}

