/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OllamaRequestLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OllamaRequestLoggingInterceptor.class);
    private static final Set<String> COMMON_SECRET_HEADERS = new HashSet<String>(Arrays.asList("authorization", "x-api-key", "x-auth-token"));

    OllamaRequestLoggingInterceptor() {
    }

    private static String getBody(Request request) {
        try {
            Buffer buffer = new Buffer();
            if (request.body() == null) {
                return "";
            }
            request.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (Exception e) {
            log.warn("Exception while getting body", (Throwable)e);
            return "Exception while getting body: " + e.getMessage();
        }
    }

    private static String getHeaders(Headers headers) {
        return StreamSupport.stream(headers.spliterator(), false).map(header -> OllamaRequestLoggingInterceptor.formatHeader((String)header.component1(), (String)header.component2())).collect(Collectors.joining(", "));
    }

    private static String formatHeader(String headerKey, String headerValue) {
        if (COMMON_SECRET_HEADERS.contains(headerKey.toLowerCase())) {
            headerValue = OllamaRequestLoggingInterceptor.maskSecretKey(headerValue);
        }
        return String.format("[%s: %s]", headerKey, headerValue);
    }

    private static String maskSecretKey(String key) {
        if (Utils.isNullOrBlank((String)key)) {
            return key;
        }
        if (key.length() >= 7) {
            return key.substring(0, 5) + "..." + key.substring(key.length() - 2);
        }
        return "...";
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.log(request);
        return chain.proceed(request);
    }

    private void log(Request request) {
        try {
            log.debug("Request:\n- method: {}\n- url: {}\n- headers: {}\n- body: {}", new Object[]{request.method(), request.url(), OllamaRequestLoggingInterceptor.getHeaders(request.headers()), OllamaRequestLoggingInterceptor.getBody(request)});
        }
        catch (Exception e) {
            log.warn("Error while logging request: {}", (Object)e.getMessage());
        }
    }
}

