/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.ollama.ChatRequest;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.OllamaMessagesUtils;
import dev.langchain4j.model.ollama.Options;
import dev.langchain4j.model.ollama.spi.OllamaStreamingChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;

public class OllamaStreamingChatModel
implements StreamingChatLanguageModel {
    private final OllamaClient client;
    private final String modelName;
    private final Options options;
    private final String format;

    public OllamaStreamingChatModel(String baseUrl, String modelName, Double temperature, Integer topK, Double topP, Double repeatPenalty, Integer seed, Integer numPredict, List<String> stop, String format, Duration timeout) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.options = Options.builder().temperature(temperature).topK(topK).topP(topP).repeatPenalty(repeatPenalty).seed(seed).numPredict(numPredict).stop(stop).build();
        this.format = format;
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ChatRequest request = ChatRequest.builder().model(this.modelName).messages(OllamaMessagesUtils.toOllamaMessages(messages)).options(this.options).format(this.format).stream(true).build();
        this.client.streamingChat(request, handler);
    }

    public static OllamaStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OllamaStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OllamaStreamingChatModelBuilderFactory factory = (OllamaStreamingChatModelBuilderFactory)iterator.next();
            return (OllamaStreamingChatModelBuilder)factory.get();
        }
        return new OllamaStreamingChatModelBuilder();
    }

    public static class OllamaStreamingChatModelBuilder {
        private String baseUrl;
        private String modelName;
        private Double temperature;
        private Integer topK;
        private Double topP;
        private Double repeatPenalty;
        private Integer seed;
        private Integer numPredict;
        private List<String> stop;
        private String format;
        private Duration timeout;

        public OllamaStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OllamaStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public OllamaStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public OllamaStreamingChatModelBuilder repeatPenalty(Double repeatPenalty) {
            this.repeatPenalty = repeatPenalty;
            return this;
        }

        public OllamaStreamingChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public OllamaStreamingChatModelBuilder numPredict(Integer numPredict) {
            this.numPredict = numPredict;
            return this;
        }

        public OllamaStreamingChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public OllamaStreamingChatModelBuilder format(String format) {
            this.format = format;
            return this;
        }

        public OllamaStreamingChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaStreamingChatModel build() {
            return new OllamaStreamingChatModel(this.baseUrl, this.modelName, this.temperature, this.topK, this.topP, this.repeatPenalty, this.seed, this.numPredict, this.stop, this.format, this.timeout);
        }

        public String toString() {
            return "OllamaStreamingChatModel.OllamaStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topK=" + this.topK + ", topP=" + this.topP + ", repeatPenalty=" + this.repeatPenalty + ", seed=" + this.seed + ", numPredict=" + this.numPredict + ", stop=" + this.stop + ", format=" + this.format + ", timeout=" + this.timeout + ")";
        }
    }
}

