/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.spi.OllamaEmbeddingModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class OllamaEmbeddingModel
implements EmbeddingModel {
    private final OllamaClient client;
    private final String modelName;
    private final Integer maxRetries;

    public OllamaEmbeddingModel(String baseUrl, String modelName, Duration timeout, Integer maxRetries) {
        this.client = OllamaClient.builder().baseUrl(baseUrl).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        ArrayList embeddings = new ArrayList();
        textSegments.forEach(textSegment -> {
            EmbeddingRequest request = EmbeddingRequest.builder().model(this.modelName).prompt(textSegment.text()).build();
            EmbeddingResponse response = (EmbeddingResponse)RetryUtils.withRetry(() -> this.client.embed(request), (int)this.maxRetries);
            embeddings.add(Embedding.from((float[])response.getEmbedding()));
        });
        return Response.from(embeddings);
    }

    public static OllamaEmbeddingModelBuilder builder() {
        return (OllamaEmbeddingModelBuilder)ServiceHelper.loadFactoryService(OllamaEmbeddingModelBuilderFactory.class, OllamaEmbeddingModelBuilder::new);
    }

    public static class OllamaEmbeddingModelBuilder {
        private String baseUrl;
        private String modelName;
        private Duration timeout;
        private Integer maxRetries;

        public OllamaEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OllamaEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OllamaEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OllamaEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OllamaEmbeddingModel build() {
            return new OllamaEmbeddingModel(this.baseUrl, this.modelName, this.timeout, this.maxRetries);
        }

        public String toString() {
            return "OllamaEmbeddingModel.OllamaEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", modelName=" + this.modelName + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

