/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.nomic;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.nomic.RequestLoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseLoggingInterceptor
implements Interceptor {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(ResponseLoggingInterceptor.class);
    private final Logger log;

    ResponseLoggingInterceptor(Logger logger) {
        this.log = (Logger)Utils.getOrDefault((Object)logger, (Object)DEFAULT_LOG);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        this.log(response);
        return response;
    }

    void log(Response response) {
        this.log.debug("Response:\n- status code: {}\n- headers: {}\n- body: {}", new Object[]{response.code(), RequestLoggingInterceptor.inOneLine(response.headers()), this.getBody(response)});
    }

    private String getBody(Response response) {
        try {
            return response.peekBody(Long.MAX_VALUE).string();
        }
        catch (IOException e) {
            this.log.warn("Failed to log response", (Throwable)e);
            return "[failed to log response]";
        }
    }
}

