/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.mistralai.InternalMistralAIHelper;
import dev.langchain4j.model.mistralai.MistralAiChatModelName;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClient;
import dev.langchain4j.model.mistralai.internal.mapper.MistralAiMapper;
import dev.langchain4j.model.mistralai.spi.MistralAiChatModelBuilderFactory;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MistralAiChatModel
implements ChatModel {
    private final MistralAiClient client;
    private final Boolean safePrompt;
    private final Integer randomSeed;
    private final Integer maxRetries;
    private final List<ChatModelListener> listeners;
    private final Set<Capability> supportedCapabilities;
    private final ChatRequestParameters defaultRequestParameters;

    public MistralAiChatModel(MistralAiChatModelBuilder builder) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().httpClientBuilder(builder.httpClientBuilder)).baseUrl((String)Utils.getOrDefault((Object)builder.baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(builder.apiKey)).timeout(builder.timeout)).logRequests((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false))).build();
        this.safePrompt = builder.safePrompt;
        this.randomSeed = builder.randomSeed;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)builder.maxRetries, (Object)2);
        this.listeners = Utils.copy(builder.listeners);
        this.supportedCapabilities = Utils.copy(builder.supportedCapabilities);
        this.defaultRequestParameters = this.initDefaultRequestParameters(builder);
    }

    private ChatRequestParameters initDefaultRequestParameters(MistralAiChatModelBuilder builder) {
        ChatRequestParameters commonParameters;
        if (builder.defaultRequestParameters != null) {
            InternalMistralAIHelper.validate(builder.defaultRequestParameters);
            commonParameters = builder.defaultRequestParameters;
        } else {
            commonParameters = DefaultChatRequestParameters.EMPTY;
        }
        return DefaultChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)builder.modelName, (Object)commonParameters.modelName())).temperature((Double)Utils.getOrDefault((Object)builder.temperature, (Object)commonParameters.temperature())).topP((Double)Utils.getOrDefault((Object)builder.topP, (Object)commonParameters.topP())).frequencyPenalty((Double)Utils.getOrDefault((Object)builder.frequencyPenalty, (Object)commonParameters.frequencyPenalty())).presencePenalty((Double)Utils.getOrDefault((Object)builder.presencePenalty, (Object)commonParameters.presencePenalty())).maxOutputTokens((Integer)Utils.getOrDefault((Object)builder.maxTokens, (Object)commonParameters.maxOutputTokens())).stopSequences(Utils.getOrDefault(builder.stopSequences, (List)commonParameters.stopSequences())).toolSpecifications(commonParameters.toolSpecifications()).toolChoice(commonParameters.toolChoice()).responseFormat((ResponseFormat)Utils.getOrDefault((Object)builder.responseFormat, (Object)commonParameters.responseFormat())).build();
    }

    @Deprecated(forRemoval=true)
    public MistralAiChatModel(HttpClientBuilder httpClientBuilder, String baseUrl, String apiKey, String modelName, Double temperature, Double topP, Integer maxTokens, Boolean safePrompt, Integer randomSeed, ResponseFormat responseFormat, Duration timeout, Boolean logRequests, Boolean logResponses, Integer maxRetries, Set<Capability> supportedCapabilities) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().httpClientBuilder(httpClientBuilder)).baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(apiKey)).timeout(timeout)).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.safePrompt = safePrompt;
        this.randomSeed = randomSeed;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
        this.listeners = List.of();
        this.supportedCapabilities = (Set)Utils.getOrDefault(supportedCapabilities, Set.of());
        this.defaultRequestParameters = this.initDefaultRequestParameters(ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName"), temperature, topP, maxTokens, responseFormat);
    }

    private ChatRequestParameters initDefaultRequestParameters(String modelName, Double temperature, Double topP, Integer maxTokens, ResponseFormat responseFormat) {
        ChatRequestParameters commonParameters = DefaultChatRequestParameters.EMPTY;
        return DefaultChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)modelName, (Object)commonParameters.modelName())).temperature((Double)Utils.getOrDefault((Object)temperature, (Object)commonParameters.temperature())).topP((Double)Utils.getOrDefault((Object)topP, (Object)commonParameters.topP())).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxTokens, (Object)commonParameters.maxOutputTokens())).responseFormat((ResponseFormat)Utils.getOrDefault((Object)responseFormat, (Object)commonParameters.responseFormat())).build();
    }

    @Deprecated(forRemoval=true)
    public MistralAiChatModel(String baseUrl, String apiKey, String modelName, Double temperature, Double topP, Integer maxTokens, Boolean safePrompt, Integer randomSeed, ResponseFormat responseFormat, Duration timeout, Boolean logRequests, Boolean logResponses, Integer maxRetries, Set<Capability> supportedCapabilities) {
        this(null, baseUrl, apiKey, modelName, temperature, topP, maxTokens, safePrompt, randomSeed, responseFormat, timeout, logRequests, logResponses, maxRetries, supportedCapabilities);
    }

    public ChatResponse doChat(ChatRequest chatRequest) {
        InternalMistralAIHelper.validate(chatRequest.parameters());
        MistralAiChatCompletionRequest request = InternalMistralAIHelper.createMistralAiRequest(chatRequest, this.safePrompt, this.randomSeed, false);
        MistralAiChatCompletionResponse mistralAiResponse = (MistralAiChatCompletionResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.chatCompletion(request), (int)this.maxRetries);
        return ChatResponse.builder().aiMessage(MistralAiMapper.aiMessageFrom(mistralAiResponse)).metadata(ChatResponseMetadata.builder().id(mistralAiResponse.getId()).modelName(mistralAiResponse.getModel()).tokenUsage(MistralAiMapper.tokenUsageFrom(mistralAiResponse.getUsage())).finishReason(MistralAiMapper.finishReasonFrom(mistralAiResponse.getChoices().get(0).getFinishReason())).build()).build();
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.MISTRAL_AI;
    }

    public Set<Capability> supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public static MistralAiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(MistralAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            MistralAiChatModelBuilderFactory factory = (MistralAiChatModelBuilderFactory)iterator.next();
            return (MistralAiChatModelBuilder)factory.get();
        }
        return new MistralAiChatModelBuilder();
    }

    public static class MistralAiChatModelBuilder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private Boolean safePrompt;
        private Integer randomSeed;
        private ResponseFormat responseFormat;
        private List<String> stopSequences;
        private Double frequencyPenalty;
        private Double presencePenalty;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxRetries;
        private List<ChatModelListener> listeners;
        private Set<Capability> supportedCapabilities;
        private ChatRequestParameters defaultRequestParameters;

        public MistralAiChatModelBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public MistralAiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MistralAiChatModelBuilder modelName(MistralAiChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public MistralAiChatModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public MistralAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public MistralAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public MistralAiChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public MistralAiChatModelBuilder safePrompt(Boolean safePrompt) {
            this.safePrompt = safePrompt;
            return this;
        }

        public MistralAiChatModelBuilder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public MistralAiChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public MistralAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiChatModelBuilder supportedCapabilities(Capability ... supportedCapabilities) {
            this.supportedCapabilities = Arrays.stream(supportedCapabilities).collect(Collectors.toSet());
            return this;
        }

        public MistralAiChatModelBuilder supportedCapabilities(Set<Capability> supportedCapabilities) {
            this.supportedCapabilities = Set.copyOf(supportedCapabilities);
            return this;
        }

        public MistralAiChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public MistralAiChatModelBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public MistralAiChatModelBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public MistralAiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public MistralAiChatModelBuilder defaultRequestParameters(ChatRequestParameters parameters) {
            this.defaultRequestParameters = parameters;
            return this;
        }

        public MistralAiChatModel build() {
            return new MistralAiChatModel(this);
        }
    }
}

