/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.embedding.DimensionAwareEmbeddingModel;
import dev.langchain4j.model.mistralai.MistralAiEmbeddingModelName;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingRequest;
import dev.langchain4j.model.mistralai.internal.api.MistralAiEmbeddingResponse;
import dev.langchain4j.model.mistralai.internal.client.MistralAiClient;
import dev.langchain4j.model.mistralai.internal.mapper.MistralAiMapper;
import dev.langchain4j.model.mistralai.spi.MistralAiEmbeddingModelBuilderFactory;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class MistralAiEmbeddingModel
extends DimensionAwareEmbeddingModel {
    private static final String EMBEDDINGS_ENCODING_FORMAT = "float";
    private final MistralAiClient client;
    private final String modelName;
    private final Integer maxRetries;

    public MistralAiEmbeddingModel(String baseUrl, String apiKey, String modelName, Duration timeout, Boolean logRequests, Boolean logResponses, Integer maxRetries) {
        this.client = ((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)((MistralAiClient.Builder)MistralAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1"))).apiKey(apiKey)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)MistralAiEmbeddingModelName.MISTRAL_EMBED.toString());
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    @Deprecated(forRemoval=true)
    public static MistralAiEmbeddingModel withApiKey(String apiKey) {
        return MistralAiEmbeddingModel.builder().apiKey(apiKey).build();
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        MistralAiEmbeddingRequest request = MistralAiEmbeddingRequest.builder().model(this.modelName).input(textSegments.stream().map(TextSegment::text).collect(Collectors.toList())).encodingFormat(EMBEDDINGS_ENCODING_FORMAT).build();
        MistralAiEmbeddingResponse response = (MistralAiEmbeddingResponse)RetryUtils.withRetry(() -> this.client.embedding(request), (int)this.maxRetries);
        List embeddings = response.getData().stream().map(mistralAiEmbedding -> Embedding.from(mistralAiEmbedding.getEmbedding())).collect(Collectors.toList());
        return Response.from(embeddings, (TokenUsage)MistralAiMapper.tokenUsageFrom(response.getUsage()));
    }

    public static MistralAiEmbeddingModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(MistralAiEmbeddingModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            MistralAiEmbeddingModelBuilderFactory factory = (MistralAiEmbeddingModelBuilderFactory)iterator.next();
            return (MistralAiEmbeddingModelBuilder)factory.get();
        }
        return new MistralAiEmbeddingModelBuilder();
    }

    public static class MistralAiEmbeddingModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxRetries;

        public MistralAiEmbeddingModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MistralAiEmbeddingModelBuilder modelName(MistralAiEmbeddingModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public MistralAiEmbeddingModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiEmbeddingModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiEmbeddingModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public MistralAiEmbeddingModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiEmbeddingModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiEmbeddingModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiEmbeddingModel build() {
            return new MistralAiEmbeddingModel(this.baseUrl, this.apiKey, this.modelName, this.timeout, this.logRequests, this.logResponses, this.maxRetries);
        }

        public String toString() {
            return "MistralAiEmbeddingModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey == null ? "" : "*****, modelName=" + this.modelName + ", timeout=" + String.valueOf(this.timeout) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

