/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.mistralai;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.mistralai.DefaultMistralAiHelper;
import dev.langchain4j.model.mistralai.MistralAiChatCompletionRequest;
import dev.langchain4j.model.mistralai.MistralAiChatCompletionResponse;
import dev.langchain4j.model.mistralai.MistralAiChatModelName;
import dev.langchain4j.model.mistralai.MistralAiClient;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;

public class MistralAiChatModel
implements ChatLanguageModel {
    private final MistralAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer maxTokens;
    private final Boolean safePrompt;
    private final Integer randomSeed;
    private final Integer maxRetries;

    public MistralAiChatModel(String baseUrl, String apiKey, String modelName, Double temperature, Double topP, Integer maxTokens, Boolean safePrompt, Integer randomSeed, Duration timeout, Boolean logRequests, Boolean logResponses, Integer maxRetries) {
        this.client = MistralAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.mistral.ai/v1")).apiKey(apiKey).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)MistralAiChatModelName.MISTRAL_TINY.toString());
        this.temperature = temperature;
        this.topP = topP;
        this.maxTokens = maxTokens;
        this.safePrompt = safePrompt;
        this.randomSeed = randomSeed;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public static MistralAiChatModel withApiKey(String apiKey) {
        return MistralAiChatModel.builder().apiKey(apiKey).build();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        MistralAiChatCompletionRequest request = MistralAiChatCompletionRequest.builder().model(this.modelName).messages(DefaultMistralAiHelper.toMistralAiMessages(messages)).temperature(this.temperature).maxTokens(this.maxTokens).topP(this.topP).randomSeed(this.randomSeed).safePrompt(this.safePrompt).stream(false).build();
        MistralAiChatCompletionResponse response = (MistralAiChatCompletionResponse)RetryUtils.withRetry(() -> this.client.chatCompletion(request), (int)this.maxRetries);
        return Response.from((Object)AiMessage.aiMessage((String)response.getChoices().get(0).getMessage().getContent()), (TokenUsage)DefaultMistralAiHelper.tokenUsageFrom(response.getUsage()), (FinishReason)DefaultMistralAiHelper.finishReasonFrom(response.getChoices().get(0).getFinishReason()));
    }

    public static MistralAiChatModelBuilder builder() {
        return new MistralAiChatModelBuilder();
    }

    public static class MistralAiChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer maxTokens;
        private Boolean safePrompt;
        private Integer randomSeed;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Integer maxRetries;

        MistralAiChatModelBuilder() {
        }

        public MistralAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public MistralAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public MistralAiChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public MistralAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public MistralAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public MistralAiChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public MistralAiChatModelBuilder safePrompt(Boolean safePrompt) {
            this.safePrompt = safePrompt;
            return this;
        }

        public MistralAiChatModelBuilder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public MistralAiChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public MistralAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public MistralAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public MistralAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public MistralAiChatModel build() {
            return new MistralAiChatModel(this.baseUrl, this.apiKey, this.modelName, this.temperature, this.topP, this.maxTokens, this.safePrompt, this.randomSeed, this.timeout, this.logRequests, this.logResponses, this.maxRetries);
        }

        public String toString() {
            return "MistralAiChatModel.MistralAiChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", maxTokens=" + this.maxTokens + ", safePrompt=" + this.safePrompt + ", randomSeed=" + this.randomSeed + ", timeout=" + this.timeout + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", maxRetries=" + this.maxRetries + ")";
        }
    }
}

