/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import dev.langchain4j.exception.ToolArgumentsException;
import dev.langchain4j.exception.ToolExecutionException;
import dev.langchain4j.service.tool.ToolExecutionResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class ToolExecutionHelper {
    private static final int ERROR_CODE_INVALID_PARAMETERS = -32602;

    ToolExecutionHelper() {
    }

    static ToolExecutionResult extractResult(JsonNode result) {
        if (result.has("result")) {
            JsonNode resultNode = result.get("result");
            if (resultNode.has("structuredContent") && !resultNode.get("structuredContent").isNull()) {
                JsonNode content = resultNode.get("structuredContent");
                if (ToolExecutionHelper.isError(resultNode)) {
                    throw new ToolExecutionException(content.toString());
                }
                return ToolExecutionResult.builder().result(ToolExecutionHelper.toObject(content)).resultText(content.toString()).build();
            }
            if (resultNode.has("content")) {
                String content = ToolExecutionHelper.extractSuccessfulResult((ArrayNode)resultNode.get("content"));
                if (ToolExecutionHelper.isError(resultNode)) {
                    throw new ToolExecutionException(content);
                }
                return ToolExecutionResult.builder().resultText(content).build();
            }
            throw new RuntimeException("Result does not contain 'content' element: " + String.valueOf(result));
        }
        if (result.has("error")) {
            String errorMessage = ToolExecutionHelper.extractErrorMessage(result.get("error"));
            Integer errorCode = ToolExecutionHelper.extractErrorCode(result.get("error"));
            if (errorCode != null && errorCode == -32602) {
                throw new ToolArgumentsException(errorMessage, errorCode);
            }
            throw new ToolExecutionException(errorMessage, errorCode);
        }
        throw new RuntimeException("Result contains neither 'result' nor 'error' element: " + String.valueOf(result));
    }

    private static Object toObject(JsonNode content) {
        return switch (content.getNodeType()) {
            default -> throw new IncompatibleClassChangeError();
            case JsonNodeType.BOOLEAN -> {
                Boolean var1_1 = content.asBoolean();
                yield var1_1;
            }
            case JsonNodeType.NUMBER -> {
                Number v1 = switch (content.numberType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case JsonParser.NumberType.INT -> content.asInt();
                    case JsonParser.NumberType.LONG, JsonParser.NumberType.BIG_INTEGER -> content.asLong();
                    case JsonParser.NumberType.FLOAT, JsonParser.NumberType.DOUBLE, JsonParser.NumberType.BIG_DECIMAL -> content.asDouble();
                };
                Number var1_2 = v1;
                yield var1_2;
            }
            case JsonNodeType.STRING -> {
                String var1_3 = content.asText();
                yield var1_3;
            }
            case JsonNodeType.NULL -> {
                String var1_4 = null;
                yield var1_4;
            }
            case JsonNodeType.ARRAY -> {
                List var1_5 = StreamSupport.stream(content.spliterator(), true).map(element -> ToolExecutionHelper.toObject(element)).collect(Collectors.toList());
                yield var1_5;
            }
            case JsonNodeType.OBJECT -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry property : content.properties()) {
                    map.put((String)property.getKey(), ToolExecutionHelper.toObject((JsonNode)property.getValue()));
                }
                HashMap<String, Object> var1_6 = map;
                yield var1_6;
            }
            case JsonNodeType.BINARY -> {
                byte[] var1_7;
                try {
                    var1_7 = content.binaryValue();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                yield var1_7;
            }
            case JsonNodeType.POJO -> {
                Object var1_8;
                yield var1_8 = new Object();
            }
            case JsonNodeType.MISSING -> {
                Object var1_9;
                yield var1_9 = new Object();
            }
        };
    }

    private static String extractSuccessfulResult(ArrayNode contents) {
        Stream<JsonNode> contentStream = StreamSupport.stream(contents.spliterator(), false);
        return contentStream.map(content -> {
            if (!content.get("type").asText().equals("text")) {
                throw new RuntimeException("Unsupported content type: " + String.valueOf(content.get("type")));
            }
            return content.get("text").asText();
        }).collect(Collectors.joining("\n"));
    }

    private static boolean isError(JsonNode resultNode) {
        if (resultNode.has("isError")) {
            return resultNode.get("isError").asBoolean();
        }
        return false;
    }

    private static String extractErrorMessage(JsonNode errorNode) {
        if (errorNode.has("message")) {
            return errorNode.get("message").asText("");
        }
        return "";
    }

    private static Integer extractErrorCode(JsonNode errorNode) {
        if (errorNode.has("code")) {
            return errorNode.get("code").asInt();
        }
        return null;
    }
}

