/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.resourcesastools;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.internal.Json;
import dev.langchain4j.mcp.client.McpClient;
import dev.langchain4j.mcp.client.McpResource;
import dev.langchain4j.mcp.client.McpResourceTemplate;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.ArrayList;
import java.util.List;

class ListResourcesToolExecutor
implements ToolExecutor {
    private final List<McpClient> mcpClients;

    ListResourcesToolExecutor(List<McpClient> mcpClients) {
        this.mcpClients = mcpClients;
    }

    public String execute(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
        ArrayList<ResourceDescription> descriptions = new ArrayList<ResourceDescription>();
        for (McpClient client : this.mcpClients) {
            for (McpResource resource : client.listResources()) {
                descriptions.add(new ResourceDescription(client.key(), resource.uri(), null, resource.name(), resource.description(), resource.mimeType()));
            }
            for (McpResourceTemplate template : client.listResourceTemplates()) {
                descriptions.add(new ResourceDescription(client.key(), null, template.uriTemplate(), template.name(), template.description(), template.mimeType()));
            }
        }
        return Json.toJson(descriptions);
    }

    private static class ResourceDescription {
        String mcpServer;
        String uri;
        String uriTemplate;
        String name;
        String description;
        String mimeType;

        ResourceDescription(String mcpServer, String uri, String uriTemplate, String name, String description, String mimeType) {
            this.mcpServer = mcpServer;
            this.uri = uri;
            this.uriTemplate = uriTemplate;
            this.name = name;
            this.description = description;
            this.mimeType = mimeType;
        }
    }
}

