/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport.stdio;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.mcp.client.protocol.CancellationNotification;
import dev.langchain4j.mcp.client.protocol.McpCallToolRequest;
import dev.langchain4j.mcp.client.protocol.McpInitializeRequest;
import dev.langchain4j.mcp.client.protocol.McpListToolsRequest;
import dev.langchain4j.mcp.client.transport.McpOperationHandler;
import dev.langchain4j.mcp.client.transport.McpTransport;
import dev.langchain4j.mcp.client.transport.stdio.ProcessIOHandler;
import dev.langchain4j.mcp.client.transport.stdio.ProcessStderrHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdioMcpTransport
implements McpTransport {
    private final List<String> command;
    private final Map<String, String> environment;
    private Process process;
    private ProcessIOHandler processIOHandler;
    private final boolean logEvents;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(StdioMcpTransport.class);
    private volatile McpOperationHandler messageHandler;

    public StdioMcpTransport(Builder builder) {
        this.command = builder.command;
        this.environment = builder.environment;
        this.logEvents = builder.logEvents;
    }

    @Override
    public void start(McpOperationHandler messageHandler) {
        this.messageHandler = messageHandler;
        log.debug("Starting process: {}", this.command);
        ProcessBuilder processBuilder = new ProcessBuilder(this.command);
        processBuilder.environment().putAll(this.environment);
        try {
            this.process = processBuilder.start();
            log.debug("PID of the started process: {}", (Object)this.process.pid());
            this.process.onExit().thenRun(() -> log.debug("Subprocess has exited with code: {}", (Object)this.process.exitValue()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.processIOHandler = new ProcessIOHandler(this.process, messageHandler, this.logEvents);
        new Thread(this.processIOHandler).start();
        new Thread(new ProcessStderrHandler(this.process)).start();
    }

    @Override
    public CompletableFuture<JsonNode> initialize(McpInitializeRequest operation) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)operation);
            return this.execute(requestString, operation.getId());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<JsonNode> listTools(McpListToolsRequest operation) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)operation);
            return this.execute(requestString, operation.getId());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<JsonNode> executeTool(McpCallToolRequest operation) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)operation);
            return this.execute(requestString, operation.getId());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cancelOperation(long operationId) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)new CancellationNotification(operationId, "Timeout"));
            this.execute(requestString, null);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.process.destroy();
    }

    private CompletableFuture<JsonNode> execute(String request, Long id) {
        CompletableFuture<JsonNode> future = new CompletableFuture<JsonNode>();
        if (id != null) {
            this.messageHandler.startOperation(id, future);
        }
        try {
            this.processIOHandler.submit(request);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public static class Builder {
        private List<String> command;
        private Map<String, String> environment;
        private boolean logEvents;

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder logEvents(boolean logEvents) {
            this.logEvents = logEvents;
            return this;
        }

        public StdioMcpTransport build() {
            if (this.command == null || this.command.isEmpty()) {
                throw new IllegalArgumentException("Missing command");
            }
            if (this.environment == null) {
                this.environment = Map.of();
            }
            return new StdioMcpTransport(this);
        }
    }
}

