/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpOperationHandler {
    private final Map<Long, CompletableFuture<JsonNode>> pendingOperations;
    private static final Logger log = LoggerFactory.getLogger(McpOperationHandler.class);

    public McpOperationHandler(Map<Long, CompletableFuture<JsonNode>> pendingOperations) {
        this.pendingOperations = pendingOperations;
    }

    public void handle(JsonNode message) {
        if (message.has("id")) {
            long messageId = message.get("id").asLong();
            CompletableFuture<JsonNode> op = this.pendingOperations.remove(messageId);
            if (op != null) {
                op.complete(message);
            } else {
                log.warn("Received response for unknown message id: {}", (Object)messageId);
            }
        } else {
            log.warn("Received message without id: {}", (Object)message);
        }
    }

    public void startOperation(Long id, CompletableFuture<JsonNode> future) {
        this.pendingOperations.put(id, future);
    }
}

