/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport.stdio;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.mcp.client.protocol.McpClientMessage;
import dev.langchain4j.mcp.client.protocol.McpInitializationNotification;
import dev.langchain4j.mcp.client.protocol.McpInitializeRequest;
import dev.langchain4j.mcp.client.transport.McpOperationHandler;
import dev.langchain4j.mcp.client.transport.McpTransport;
import dev.langchain4j.mcp.client.transport.stdio.ProcessIOHandler;
import dev.langchain4j.mcp.client.transport.stdio.ProcessStderrHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdioMcpTransport
implements McpTransport {
    private final List<String> command;
    private final Map<String, String> environment;
    private Process process;
    private ProcessIOHandler processIOHandler;
    private final boolean logEvents;
    private final Logger logger;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(StdioMcpTransport.class);
    private volatile McpOperationHandler messageHandler;
    private ProcessStderrHandler stderrHandler;

    public StdioMcpTransport(Builder builder) {
        this.command = builder.command;
        this.environment = builder.environment;
        this.logEvents = builder.logEvents;
        this.logger = builder.logger;
    }

    @Override
    public void start(McpOperationHandler messageHandler) {
        this.messageHandler = messageHandler;
        log.debug("Starting process: {}", this.command);
        ProcessBuilder processBuilder = new ProcessBuilder(this.command);
        processBuilder.environment().putAll(this.environment);
        try {
            this.process = processBuilder.start();
            log.debug("PID of the started process: {}", (Object)this.process.pid());
            this.process.onExit().thenRun(() -> log.debug("Subprocess has exited with code: {}", (Object)this.process.exitValue()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.processIOHandler = new ProcessIOHandler(this.process, messageHandler, this.logEvents, this.logger);
        new Thread(this.processIOHandler).start();
        this.stderrHandler = new ProcessStderrHandler(this.process);
        new Thread(this.stderrHandler).start();
    }

    @Override
    public CompletableFuture<JsonNode> initialize(McpInitializeRequest operation) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)operation);
            String initializationNotification = OBJECT_MAPPER.writeValueAsString((Object)new McpInitializationNotification());
            return this.execute(requestString, operation.getId()).thenCompose(originalResponse -> this.execute(initializationNotification, null).thenCompose(nullNode -> CompletableFuture.completedFuture(originalResponse)));
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<JsonNode> executeOperationWithResponse(McpClientMessage operation) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)operation);
            return this.execute(requestString, operation.getId());
        }
        catch (JsonProcessingException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public void executeOperationWithoutResponse(McpClientMessage operation) {
        try {
            String requestString = OBJECT_MAPPER.writeValueAsString((Object)operation);
            this.execute(requestString, null);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkHealth() {
        if (!this.process.isAlive()) {
            throw new IllegalStateException("Process is not alive");
        }
    }

    @Override
    public void onFailure(Runnable actionOnFailure) {
    }

    @Override
    public void close() throws IOException {
        try {
            this.stderrHandler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.processIOHandler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.process.destroy();
    }

    private CompletableFuture<JsonNode> execute(String request, Long id) {
        CompletableFuture<JsonNode> future = new CompletableFuture<JsonNode>();
        if (id != null) {
            this.messageHandler.startOperation(id, future);
        }
        try {
            this.processIOHandler.submit(request);
            if (id == null) {
                future.complete(null);
            }
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public Process getProcess() {
        return this.process;
    }

    public static class Builder {
        private List<String> command;
        private Map<String, String> environment;
        private boolean logEvents;
        private Logger logger;

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder logEvents(boolean logEvents) {
            this.logEvents = logEvents;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public StdioMcpTransport build() {
            ValidationUtils.ensureNotEmpty(this.command, (String)"command");
            if (this.environment == null) {
                this.environment = Map.of();
            }
            return new StdioMcpTransport(this);
        }
    }
}

