/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import dev.langchain4j.mcp.client.transport.McpOperationHandler;
import dev.langchain4j.mcp.client.transport.websocket.WebSocketMcpTransport;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketMcpListener
implements WebSocket.Listener {
    private final McpOperationHandler operationHandler;
    private final Logger trafficLogger;
    private final boolean logResponses;
    private final Runnable onCloseCallback;
    private final Logger logger = LoggerFactory.getLogger(WebSocketMcpListener.class);
    private final Runnable onFailureCallback;
    private volatile StringBuilder receivedMessage = new StringBuilder();

    public WebSocketMcpListener(McpOperationHandler operationHandler, Logger trafficLogger, boolean logResponses, Runnable onCloseCallback, Runnable onFailureCallback) {
        this.operationHandler = operationHandler;
        this.trafficLogger = trafficLogger;
        this.logResponses = logResponses;
        this.onCloseCallback = onCloseCallback;
        this.onFailureCallback = onFailureCallback;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.logger.debug("Websocket connection opened");
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.receivedMessage.append(data);
        if (last) {
            String completeMessage = this.receivedMessage.toString();
            this.receivedMessage = new StringBuilder();
            if (this.logResponses) {
                this.trafficLogger.info("< " + completeMessage);
            }
            try {
                JsonNode jsonNode = WebSocketMcpTransport.OBJECT_MAPPER.readTree(completeMessage);
                this.operationHandler.handle(jsonNode);
            }
            catch (JsonProcessingException e) {
                this.logger.warn("Failed to parse JSON message: {}", (Object)completeMessage, (Object)e);
            }
        }
        webSocket.request(1L);
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.logger.debug("Websocket connection closed with status {} and reason: {}", (Object)statusCode, (Object)reason);
        this.operationHandler.cancelAllPendingOperations("Status " + statusCode + ", Reason: " + reason);
        this.onCloseCallback.run();
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        this.logger.warn("WebSocket error", error);
        this.onFailureCallback.run();
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        this.logger.warn("Received binary data, this is not supported");
        webSocket.request(1L);
        return null;
    }
}

