/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.mariadb;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.mariadb.MariaDbValidator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record MetadataColumDefinition(String fullDefinition, String escapedName, String name, String type) {
    private static final Pattern litteralPattern = Pattern.compile("^(([a-zA-Z0-9_]+)|(`((``)|[^`])+`))", 32);

    public static MetadataColumDefinition from(String sqlDefinition, List<String> sqlKeywords) {
        Object fullDefinition = ((String)ValidationUtils.ensureNotNull((Object)sqlDefinition, (String)"Metadata column definition")).trim();
        Matcher matcher = litteralPattern.matcher(sqlDefinition);
        if (matcher.find()) {
            String fieldName = matcher.group(0);
            String remainingDefinition = ((String)fullDefinition).substring(fieldName.length()).trim();
            if (remainingDefinition.isEmpty()) {
                throw new IllegalArgumentException("Definition format should be: <column name> <type>  [ NULL | NOT NULL ] [ UNIQUE ] [ DEFAULT value ]");
            }
            String escapedName = fieldName;
            String unescapedName = fieldName.startsWith("`") ? fieldName.substring(1, fieldName.length() - 1) : fieldName;
            String type = ((String)fullDefinition).substring(fieldName.length()).trim().split(" ")[0].toLowerCase();
            if (!fieldName.startsWith("`") && sqlKeywords.contains(unescapedName.toLowerCase(Locale.ROOT))) {
                escapedName = MariaDbValidator.validateAndEnquoteIdentifier(unescapedName, true);
                fullDefinition = escapedName + ((String)fullDefinition).substring(fieldName.length());
            }
            return new MetadataColumDefinition((String)fullDefinition, escapedName, unescapedName, type);
        }
        throw new IllegalArgumentException("Wrong definition format should be: <column name> <type>  [ NULL | NOT NULL ] [ UNIQUE ] [ DEFAULT value ]");
    }
}

