/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client.jdk;

import dev.langchain4j.Experimental;
import dev.langchain4j.http.client.FormDataFile;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

@Experimental
class MultipartBodyPublisher {
    private static final String BOUNDARY = "----LangChain4j";
    private static final String CRLF = "\r\n";
    private final List<byte[]> parts = new ArrayList<byte[]>();

    MultipartBodyPublisher() {
    }

    List<byte[]> parts() {
        return this.parts;
    }

    void addField(String name, String value) {
        String part = "------LangChain4j\r\nContent-Disposition: form-data; name=\"" + name + "\"\r\n\r\n" + value + CRLF;
        this.parts.add(part.getBytes(StandardCharsets.UTF_8));
    }

    void addFile(String name, FormDataFile file) {
        String header = "------LangChain4j\r\nContent-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.fileName() + "\"\r\nContent-Type: " + file.contentType() + "\r\n\r\n";
        this.parts.add(header.getBytes(StandardCharsets.UTF_8));
        this.parts.add(file.content());
        this.parts.add(CRLF.getBytes(StandardCharsets.UTF_8));
    }

    HttpRequest.BodyPublisher build() {
        String end = "------LangChain4j--\r\n";
        this.parts.add(end.getBytes(StandardCharsets.UTF_8));
        return HttpRequest.BodyPublishers.ofByteArrays(this.parts);
    }
}

