/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.gpullama3;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.gpullama3.GPULlama3BaseModel;
import dev.langchain4j.model.gpullama3.GPULlama3ResponseParser;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class GPULlama3StreamingChatModel
extends GPULlama3BaseModel
implements StreamingChatModel {
    private GPULlama3StreamingChatModel(Builder builder) {
        this.init(Objects.requireNonNull(builder.modelPath, "modelPath is required and must be specified"), (Double)Utils.getOrDefault((Object)builder.temperature, (Object)0.1), (Double)Utils.getOrDefault((Object)builder.topP, (Object)1.0), (Integer)Utils.getOrDefault((Object)builder.seed, (Object)12345), (Integer)Utils.getOrDefault((Object)builder.maxTokens, (Object)512), (Boolean)Utils.getOrDefault((Object)builder.onGPU, (Object)Boolean.TRUE));
    }

    public static Builder builder() {
        return new Builder();
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        ChatRequestValidationUtils.validateMessages((List)chatRequest.messages());
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidationUtils.validate((ToolChoice)parameters.toolChoice());
        ChatRequestValidationUtils.validate((ResponseFormat)parameters.responseFormat());
        try {
            GPULlama3ResponseParser.StreamingParser parser = GPULlama3ResponseParser.createStreamingParser(handler, this.getModel());
            String rawResponse = this.modelResponse(chatRequest, parser::onToken);
            GPULlama3ResponseParser.ParsedResponse parsed = GPULlama3ResponseParser.parseResponse(rawResponse);
            ChatResponse chatResponse = ChatResponse.builder().aiMessage(AiMessage.builder().text(parsed.getActualResponse()).thinking(parsed.getThinkingContent()).build()).build();
            handler.onCompleteResponse(chatResponse);
        }
        catch (Exception e) {
            handler.onError((Throwable)e);
        }
    }

    public static class Builder {
        protected Path modelPath;
        protected Double temperature;
        protected Double topP;
        protected Integer seed;
        protected Integer maxTokens;
        protected Boolean onGPU;

        public Builder modelPath(Path modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder onGPU(Boolean onGPU) {
            this.onGPU = onGPU;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public GPULlama3StreamingChatModel build() {
            return new GPULlama3StreamingChatModel(this);
        }
    }
}

