/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.BertTokenizer;
import dev.langchain4j.model.embedding.PoolingMode;
import java.io.InputStream;
import java.net.URL;

public class OnnxBertBiEncoder {
    private static final String CLS = "[CLS]";
    private static final String SEP = "[SEP]";
    private static final int MAX_SEQUENCE_LENGTH = 510;
    private final OrtEnvironment environment;
    private final OrtSession session;
    private final BertTokenizer tokenizer;
    private final PoolingMode poolingMode;

    public OnnxBertBiEncoder(InputStream modelInputStream, URL vocabularyFile, PoolingMode poolingMode) {
        try {
            this.environment = OrtEnvironment.getEnvironment();
            this.session = this.environment.createSession(this.loadModel(modelInputStream));
            this.tokenizer = new BertTokenizer(vocabularyFile);
            this.poolingMode = (PoolingMode)((Object)ValidationUtils.ensureNotNull((Object)((Object)poolingMode), (String)"poolingMode"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[] embed(String text) {
        int tokenCount = this.tokenizer.estimateTokenCountInText(text);
        if (tokenCount > 510) {
            throw Exceptions.illegalArgument((String)"Cannot embed text longer than %s tokens. The following text is %s tokens long: %s", (Object[])new Object[]{510, tokenCount, text});
        }
        try (OrtSession.Result result = this.encode(text);){
            float[] fArray = this.toEmbedding(result);
            return fArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private OrtSession.Result encode(String text) throws OrtException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private byte[] loadModel(InputStream modelInputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private float[] toEmbedding(OrtSession.Result result) throws OrtException {
        float[][] vectors = ((float[][][])result.get(0).getValue())[0];
        return OnnxBertBiEncoder.normalize(this.pool(vectors));
    }

    private float[] pool(float[][] vectors) {
        switch (this.poolingMode) {
            case CLS: {
                return OnnxBertBiEncoder.clsPool(vectors);
            }
            case MEAN: {
                return OnnxBertBiEncoder.meanPool(vectors);
            }
        }
        throw Exceptions.illegalArgument((String)("Unknown pooling mode: " + (Object)((Object)this.poolingMode)), (Object[])new Object[0]);
    }

    private static float[] clsPool(float[][] vectors) {
        return vectors[0];
    }

    private static float[] meanPool(float[][] vectors) {
        int numVectors = vectors.length;
        int vectorLength = vectors[0].length;
        float[] averagedVector = new float[vectorLength];
        for (float[] vector : vectors) {
            for (int j = 0; j < vectorLength; ++j) {
                int n = j;
                averagedVector[n] = averagedVector[n] + vector[j];
            }
        }
        int j = 0;
        while (j < vectorLength) {
            int n = j++;
            averagedVector[n] = averagedVector[n] / (float)numVectors;
        }
        return averagedVector;
    }

    private static float[] normalize(float[] vector) {
        float sumSquare = 0.0f;
        for (float v : vector) {
            sumSquare += v * v;
        }
        float norm = (float)Math.sqrt(sumSquare);
        float[] normalizedVector = new float[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            normalizedVector[i] = vector[i] / norm;
        }
        return normalizedVector;
    }

    int countTokens(String text) {
        return this.tokenizer.tokenize(text).size();
    }
}

