/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.embedding.OnnxBertEmbeddingModel;
import dev.langchain4j.model.embedding.TokenCountEstimator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractInProcessEmbeddingModel
implements EmbeddingModel,
TokenCountEstimator {
    private static final int BERT_MAX_TOKENS = 510;

    static OnnxBertEmbeddingModel loadFromJar(String modelFileName) {
        InputStream inputStream = AbstractInProcessEmbeddingModel.class.getResourceAsStream("/" + modelFileName);
        return new OnnxBertEmbeddingModel(inputStream);
    }

    static OnnxBertEmbeddingModel loadFromFileSystem(Path pathToModel) {
        try {
            return new OnnxBertEmbeddingModel(Files.newInputStream(pathToModel, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract OnnxBertEmbeddingModel model();

    public List<Embedding> embedAll(List<TextSegment> segments) {
        return segments.stream().map(segment -> {
            String text = segment.text();
            int tokenCount = this.estimateTokenCount(text);
            if (tokenCount > 510) {
                throw Exceptions.illegalArgument((String)"Cannot embed text longer than %s tokens. The following text is %s tokens long: %s", (Object[])new Object[]{510, tokenCount, text});
            }
            float[] vector = this.model().embed(text);
            return Embedding.from((float[])vector);
        }).collect(Collectors.toList());
    }

    public int estimateTokenCount(String text) {
        return this.model().countTokens(text);
    }
}

