/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser.apache.tika;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.internal.Utils;
import java.io.InputStream;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class ApacheTikaDocumentParser
implements DocumentParser {
    private static final int NO_WRITE_LIMIT = -1;
    private final Parser parser;
    private final ContentHandler contentHandler;
    private final Metadata metadata;
    private final ParseContext parseContext;

    public ApacheTikaDocumentParser() {
        this(null, null, null, null);
    }

    public ApacheTikaDocumentParser(Parser parser, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
        this.parser = (Parser)Utils.getOrDefault((Object)parser, AutoDetectParser::new);
        this.contentHandler = (ContentHandler)Utils.getOrDefault((Object)contentHandler, () -> new BodyContentHandler(-1));
        this.metadata = (Metadata)Utils.getOrDefault((Object)metadata, Metadata::new);
        this.parseContext = (ParseContext)Utils.getOrDefault((Object)parseContext, ParseContext::new);
    }

    public Document parse(InputStream inputStream) {
        try {
            this.parser.parse(inputStream, this.contentHandler, this.metadata, this.parseContext);
            String text = this.contentHandler.toString();
            if (Utils.isNullOrBlank((String)text)) {
                throw new BlankDocumentException();
            }
            return Document.from((String)text);
        }
        catch (BlankDocumentException e) {
            throw e;
        }
        catch (ZeroByteFileException e) {
            throw new BlankDocumentException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

